/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy;

import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.InkColor;

public interface InkStorageBlockEntity<PStorage extends InkStorage> {
    public PStorage getEnergyStorage();

    default public float drainInkForMod(float mod, InkColor inkColor) {
        return this.drainInkForMod(mod, inkColor, 1.0f);
    }

    default public float drainInkForMod(float mod, InkColor inkColor, float efficiencyMod) {
        if (mod > 1.0f) {
            int cost = (int)((double)(mod * mod - 1.0f) / Math.pow(2.0, efficiencyMod));
            if (this.getEnergyStorage().drainEnergy(inkColor, cost) == (long)cost) {
                return mod;
            }
            this.setInkDirty();
            return 1.0f;
        }
        return 1.0f;
    }

    public void setInkDirty();

    public boolean getInkDirty();
}

