/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.color;

import de.dafuqs.spectrum.energy.color.ElementalColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class InkColor {
    protected static final Map<class_1767, InkColor> DYE_TO_COLOR = new HashMap<class_1767, InkColor>();
    protected static final List<InkColor> ALL_COLORS = new ArrayList<InkColor>();
    protected static final List<ElementalColor> ELEMENTAL_COLORS = new ArrayList<ElementalColor>();
    protected final class_1767 dyeColor;
    protected final class_1160 color;
    protected final class_2960 requiredAdvancement;

    protected InkColor(class_1767 dyeColor, class_1160 color, class_2960 requiredAdvancement) {
        this.dyeColor = dyeColor;
        this.color = color;
        this.requiredAdvancement = requiredAdvancement;
        ALL_COLORS.add(this);
        DYE_TO_COLOR.put(dyeColor, this);
    }

    public static InkColor of(class_1767 dyeColor) {
        return DYE_TO_COLOR.get(dyeColor);
    }

    public static InkColor of(String colorString) {
        return DYE_TO_COLOR.get(class_1767.valueOf((String)colorString.toUpperCase(Locale.ROOT)));
    }

    public static List<InkColor> all() {
        return ALL_COLORS;
    }

    public static List<ElementalColor> elementals() {
        return ELEMENTAL_COLORS;
    }

    public class_1767 getDyeColor() {
        return this.dyeColor;
    }

    public String toString() {
        return this.dyeColor.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InkColor that = (InkColor)o;
        return this.dyeColor.equals((Object)that.dyeColor);
    }

    public int hashCode() {
        return this.dyeColor.method_7789();
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)("spectrum.ink.color." + this));
    }

    public class_1160 getColor() {
        return this.color;
    }

    public class_2960 getRequiredAdvancement() {
        return this.requiredAdvancement;
    }
}

