/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.TotalCappedElementalInkStorage;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtistsPaletteInkStorage
extends TotalCappedElementalInkStorage {
    public ArtistsPaletteInkStorage(long maxEnergyTotal) {
        super(maxEnergyTotal);
    }

    public ArtistsPaletteInkStorage(long maxEnergyTotal, long cyan, long magenta, long yellow, long black, long white) {
        super(maxEnergyTotal, cyan, magenta, yellow, black, white);
    }

    @Nullable
    public static ArtistsPaletteInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            long cyan = compound.method_10537("Cyan");
            long magenta = compound.method_10537("Magenta");
            long yellow = compound.method_10537("Yellow");
            long black = compound.method_10537("Black");
            long white = compound.method_10537("White");
            return new ArtistsPaletteInkStorage(maxEnergyTotal, cyan, magenta, yellow, black, white);
        }
        return null;
    }

    public long addEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        long leftoverEnergy = super.addEnergy(color, amount);
        if (leftoverEnergy != amount) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, amount - leftoverEnergy);
        }
        return leftoverEnergy;
    }

    public boolean requestEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        boolean success = super.requestEnergy(color, amount);
        if (success) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, -amount);
        }
        return success;
    }

    public long drainEnergy(InkColor color, long amount, class_1799 stack, class_3222 serverPlayerEntity) {
        long drainedAmount = super.drainEnergy(color, amount);
        if (drainedAmount != 0L) {
            SpectrumAdvancementCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, this, color, -drainedAmount);
        }
        return drainedAmount;
    }
}

