/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.SingleInkStorage;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedSingleInkStorage
extends SingleInkStorage {
    public FixedSingleInkStorage(long maxEnergy, InkColor color) {
        super(maxEnergy);
        this.storedColor = color;
    }

    public FixedSingleInkStorage(long maxEnergy, InkColor color, long amount) {
        super(maxEnergy, color, amount);
    }

    @Nullable
    public static FixedSingleInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            InkColor color = InkColor.of(compound.method_10558("Color"));
            long amount = compound.method_10537("Amount");
            return new FixedSingleInkStorage(maxEnergyTotal, color, amount);
        }
        return null;
    }

    @Override
    public InkColor getStoredColor() {
        return this.storedColor;
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedColor == color;
    }

    @Override
    public long getRoom(InkColor color) {
        if (this.storedColor == color) {
            return this.maxEnergy - this.storedEnergy;
        }
        return 0L;
    }
}

