/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.Support;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInkStorage
implements InkStorage {
    protected final long maxEnergy;
    protected InkColor storedColor;
    protected long storedEnergy;

    public SingleInkStorage(long maxEnergy) {
        this.maxEnergy = maxEnergy;
        this.storedColor = InkColors.CYAN;
        this.storedEnergy = 0L;
    }

    public SingleInkStorage(long maxEnergy, InkColor color, long amount) {
        this.maxEnergy = maxEnergy;
        this.storedColor = color;
        this.storedEnergy = amount;
    }

    @Nullable
    public static SingleInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            InkColor color = InkColor.of(compound.method_10558("Color"));
            long amount = compound.method_10537("Amount");
            return new SingleInkStorage(maxEnergyTotal, color, amount);
        }
        return null;
    }

    public InkColor getStoredColor() {
        return this.storedColor;
    }

    @Override
    public boolean accepts(InkColor color) {
        return this.storedEnergy == 0L || this.storedColor == color;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        if (color == this.storedColor) {
            long resultingAmount;
            this.storedEnergy = resultingAmount = this.storedEnergy + amount;
            if (resultingAmount > this.maxEnergy) {
                long overflow = this.storedEnergy - this.maxEnergy;
                this.storedEnergy = this.maxEnergy;
                return overflow;
            }
            return 0L;
        }
        if (this.storedEnergy == 0L) {
            this.storedColor = color;
            this.storedEnergy = amount;
        }
        return amount;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        if (color == this.storedColor && amount >= this.storedEnergy) {
            this.storedEnergy -= amount;
            return true;
        }
        return false;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        if (color == this.storedColor) {
            long drainedAmount = Math.min(this.storedEnergy, amount);
            this.storedEnergy -= drainedAmount;
            return drainedAmount;
        }
        return 0L;
    }

    @Override
    public long getEnergy(InkColor color) {
        if (color == this.storedColor) {
            return this.storedEnergy;
        }
        return 0L;
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return Map.of(this.storedColor, this.storedEnergy);
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            long value = color.getValue();
            if (value <= 0L) continue;
            this.storedColor = color.getKey();
            this.storedEnergy = color.getValue();
        }
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergy;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergy;
    }

    @Override
    public long getCurrentTotal() {
        return this.storedEnergy;
    }

    @Override
    public boolean isEmpty() {
        return this.storedEnergy == 0L;
    }

    @Override
    public boolean isFull() {
        return this.storedEnergy >= this.maxEnergy;
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10544("MaxEnergyTotal", this.maxEnergy);
        compound.method_10582("Color", this.storedColor.toString());
        compound.method_10544("Amount", this.storedEnergy);
        return compound;
    }

    @Override
    public void addTooltip(List<class_2561> tooltip, boolean includeHeader) {
        if (includeHeader) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ink_flask.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergy)}));
        }
        if (this.storedEnergy > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)("spectrum.tooltip.ink_powered.bullet." + this.storedColor.toString().toLowerCase(Locale.ROOT)), (Object[])new Object[]{Support.getShortenedNumberString(this.storedEnergy)}));
        }
    }

    @Override
    public long getRoom(InkColor color) {
        if (this.storedEnergy == 0L || this.storedColor == color) {
            return this.maxEnergy - this.storedEnergy;
        }
        return 0L;
    }

    @Override
    public void fillCompletely() {
        this.storedEnergy = this.maxEnergy;
    }

    @Override
    public void clear() {
        this.storedEnergy = 0L;
    }

    public void convertColor(InkColor color) {
        this.storedColor = color;
    }
}

