/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.energy.storage;

import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.ElementalColor;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.Support;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotalCappedInkStorage
implements InkStorage {
    protected final long maxEnergyTotal;
    protected final Map<InkColor, Long> storedEnergy;
    protected long currentTotal;

    public TotalCappedInkStorage(long maxEnergyTotal) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.currentTotal = 0L;
        this.storedEnergy = new HashMap<InkColor, Long>();
        for (InkColor color : InkColor.all()) {
            this.storedEnergy.put(color, 0L);
        }
    }

    public TotalCappedInkStorage(long maxEnergyTotal, Map<InkColor, Long> colors) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.storedEnergy = colors;
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            this.storedEnergy.put(color.getKey(), color.getValue());
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Nullable
    public static TotalCappedInkStorage fromNbt(@NotNull class_2487 compound) {
        if (compound.method_10573("MaxEnergyTotal", 4)) {
            long maxEnergyTotal = compound.method_10537("MaxEnergyTotal");
            HashMap<InkColor, Long> colors = new HashMap<InkColor, Long>();
            for (InkColor color : InkColor.all()) {
                colors.put(color, compound.method_10537(color.toString()));
            }
            return new TotalCappedInkStorage(maxEnergyTotal, colors);
        }
        return null;
    }

    @Override
    public boolean accepts(InkColor color) {
        return color instanceof ElementalColor;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long currentAmount = this.storedEnergy.get(color);
        if (amount > this.maxEnergyTotal - this.currentTotal) {
            long resultingAmount = currentAmount + amount;
            long overflow = resultingAmount - this.maxEnergyTotal + this.currentTotal;
            this.currentTotal += resultingAmount - this.maxEnergyTotal;
            this.storedEnergy.put(color, this.maxEnergyTotal);
            return overflow;
        }
        this.currentTotal += amount;
        this.storedEnergy.put(color, currentAmount + amount);
        return 0L;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.get(color);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.get(color);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.get(color);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.maxEnergyTotal;
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10544("MaxEnergyTotal", this.maxEnergyTotal);
        for (Map.Entry<InkColor, Long> color : this.storedEnergy.entrySet()) {
            compound.method_10544(color.getKey().toString(), color.getValue().longValue());
        }
        return compound;
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyTotal - this.currentTotal;
    }

    @Override
    public void fillCompletely() {
        long energyPerColor = this.maxEnergyTotal / (long)this.storedEnergy.size();
        this.storedEnergy.replaceAll((c, v) -> energyPerColor);
        this.currentTotal += (long)this.storedEnergy.size() * energyPerColor;
    }

    @Override
    public void clear() {
        this.storedEnergy.replaceAll((c, v) -> 0L);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addTooltip(List<class_2561> tooltip, boolean includeHeader) {
        if (includeHeader) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.total_capped_simple_pigment_energy_storage.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyTotal)}));
        }
        for (Map.Entry<InkColor, Long> color : this.storedEnergy.entrySet()) {
            if (color.getValue() <= 0L) continue;
            tooltip.add((class_2561)class_2561.method_43469((String)("spectrum.tooltip.ink_powered.bullet." + color.getKey().toString().toLowerCase(Locale.ROOT)), (Object[])new Object[]{Support.getShortenedNumberString(color.getValue())}));
        }
    }
}

