/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.blocks.gravity.FloatBlock;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.id.incubus_core.blocklikeentities.api.BlockLikeEntity;
import net.id.incubus_core.blocklikeentities.util.PostTickEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class FloatBlockEntity
extends BlockLikeEntity
implements PostTickEntity {
    private static final float MAX_DAMAGE = 5.0f;
    private static final float DAMAGE_PER_FALLEN_BLOCK = 0.5f;
    private float gravityModifier = 1.0f;

    public FloatBlockEntity(class_1299<? extends FloatBlockEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FloatBlockEntity(class_1937 world, double x, double y, double z, class_2680 blockState) {
        this(SpectrumEntityTypes.FLOAT_BLOCK, world);
        this.blockState = blockState;
        this.field_23807 = true;
        this.method_5814(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setOrigin(new class_2338(this.method_19538()));
        this.gravityModifier = blockState.method_26204() instanceof FloatBlock ? ((FloatBlock)blockState.method_26204()).getGravityMod() : 1.0f;
    }

    public FloatBlockEntity(class_1937 world, class_2338 pos, class_2680 blockState, boolean partOfSet) {
        this(world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, blockState);
        this.partOfSet = partOfSet;
    }

    public void postTickMovement() {
        if (!this.method_5740()) {
            if (this.gravityModifier != 0.0f) {
                if (this.moveTime > 100) {
                    this.method_5762(0.0, this.gravityModifier / 10.0f, 0.0);
                } else {
                    this.method_5762(0.0, Math.min(Math.sin(Math.PI * (double)this.field_6012 / 100.0), 1.0) * (double)(this.gravityModifier / 10.0f), 0.0);
                }
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
    }

    public void method_5773() {
    }

    public void postTickMoveEntities() {
        super.postTickMoveEntities();
        List otherEntities = this.field_6002.method_8335((class_1297)this, this.method_5829().method_991(this.method_5829().method_989(0.0, 2.0 * (this.field_6036 - this.method_23318()), 0.0)));
        for (class_1297 entity : otherEntities) {
            if (entity instanceof BlockLikeEntity || entity.field_5960 || !this.method_30948()) continue;
            entity.method_5814(entity.method_23317(), this.method_5829().field_1325, entity.method_23321());
        }
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean shouldCease() {
        return this.field_5992 || super.shouldCease();
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 damageSource) {
        int damage;
        int traveledDistance;
        if (!this.field_6002.field_9236 && (traveledDistance = class_3532.method_15386((float)(distance - 1.0f))) > 0 && (damage = (int)Math.min((float)class_3532.method_15375((float)((float)traveledDistance * 0.5f)), 5.0f)) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_6002.method_8335((class_1297)this, this.method_5829().method_1009(0.0, 3.0 * Math.signum(this.method_18798().field_1351), 0.0).method_1009(0.0, -0.5 * Math.signum(this.method_18798().field_1351), 0.0)));
            for (class_1297 entity : list) {
                entity.method_5643(SpectrumDamageSources.FLOATBLOCK, (float)damage);
            }
        }
        return false;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.field_6002.field_9236 && player.method_5715()) {
            class_1792 item = this.blockState.method_26204().method_8389();
            if (item != null) {
                Support.givePlayer(player, item.method_7854());
                this.method_31472();
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.gravityModifier = this.blockState.method_26204() instanceof FloatBlock ? ((FloatBlock)this.blockState.method_26204()).getGravityMod() : 1.0f;
    }

    public void postTickEntityCollision(class_1297 entity) {
        super.postTickEntityCollision(entity);
        if (this.isPaltaeriaStratineCollision(entity)) {
            this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, class_1927.class_4179.field_18685);
            this.method_31472();
            entity.method_31472();
            class_1799 collisionStack = SpectrumBlocks.HOVER_BLOCK.method_8389().method_7854();
            class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), collisionStack);
            itemEntity.method_5762(0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2, 0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2, 0.1 - (double)this.field_6002.field_9229.method_43057() * 0.2);
            this.field_6002.method_8649((class_1297)itemEntity);
        }
    }

    public boolean isPaltaeriaStratineCollision(class_1297 other) {
        if (other instanceof BlockLikeEntity) {
            BlockLikeEntity otherBlockLikeEntity = (BlockLikeEntity)other;
            class_2248 thisBlock = this.blockState.method_26204();
            class_2248 otherBlock = otherBlockLikeEntity.getBlockState().method_26204();
            return thisBlock == SpectrumBlocks.PALTAERIA_FRAGMENT_BLOCK && otherBlock == SpectrumBlocks.STRATINE_FRAGMENT_BLOCK || thisBlock == SpectrumBlocks.STRATINE_FRAGMENT_BLOCK && otherBlock == SpectrumBlocks.PALTAERIA_FRAGMENT_BLOCK;
        }
        return false;
    }
}

