/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.helpers.BlockVariantHelper;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.InkProjectileSoundInstance;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1767;
import net.minecraft.class_1890;
import net.minecraft.class_1900;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class InkProjectileEntity
extends class_1676 {
    private static final int COLOR_SPLAT_RANGE = 2;
    private static final int SPELL_POTENCY = 2;
    private static final float DAMAGE_PER_POTENCY = 0.5f;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(InkProjectileEntity.class, (class_2941)class_2943.field_13327);
    protected int life;

    public InkProjectileEntity(class_1299<InkProjectileEntity> type, class_1937 world) {
        super(type, world);
        if (world.field_9236) {
            InkProjectileSoundInstance.startSoundInstance(this);
        }
    }

    public InkProjectileEntity(class_1299<InkProjectileEntity> type, double x, double y, double z, class_1937 world) {
        this(type, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
    }

    public InkProjectileEntity(class_1937 world, class_1309 owner) {
        this(SpectrumEntityTypes.INK_PROJECTILE, owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321(), world);
        this.method_7432((class_1297)owner);
        this.method_5710(owner.method_36454(), owner.method_36455());
    }

    protected void method_5693() {
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public class_1767 getDyeColor() {
        return class_1767.method_7791((int)((Integer)this.field_6011.method_12789(COLOR)));
    }

    public void setColor(InkColor inkColor) {
        this.field_6011.method_12778(COLOR, (Object)inkColor.getDyeColor().method_7789());
    }

    protected void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        int color = this.getColor();
        if (color != -1) {
            nbt.method_10569("Color", color);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        }
    }

    public void method_5773() {
        super.method_5773();
        this.spawnParticles(1);
        boolean noClip = this.isNoClip();
        class_243 thisVelocity = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double d = thisVelocity.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)thisVelocity.field_1352, (double)thisVelocity.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)thisVelocity.field_1351, (double)d) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        this.age();
        class_243 thisPos = this.method_19538();
        class_243 vec3d2 = thisPos.method_1019(thisVelocity);
        class_3965 hitResult = this.field_6002.method_17742(new class_3959(thisPos, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            vec3d2 = hitResult.method_17784();
        }
        if (!this.method_31481()) {
            class_3966 entityHitResult = this.getEntityCollision(thisPos, vec3d2);
            if (entityHitResult != null) {
                hitResult = entityHitResult;
            }
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                class_1297 entity = ((class_3966)hitResult).method_17782();
                class_1297 entity2 = this.method_24921();
                if (entity instanceof class_1657 && entity2 instanceof class_1657 && !((class_1657)entity2).method_7256((class_1657)entity)) {
                    hitResult = null;
                }
            }
            if (hitResult != null && !noClip) {
                this.method_7488((class_239)hitResult);
                this.field_6007 = true;
            }
        }
        thisVelocity = this.method_18798();
        double velocityX = thisVelocity.field_1352;
        double velocityY = thisVelocity.field_1351;
        double velocityZ = thisVelocity.field_1350;
        double h = this.method_23317() + velocityX;
        double j = this.method_23318() + velocityY;
        double k = this.method_23321() + velocityZ;
        double l = thisVelocity.method_37267();
        if (noClip) {
            this.method_36456((float)(class_3532.method_15349((double)(-velocityX), (double)(-velocityZ)) * 57.2957763671875));
        } else {
            this.method_36456((float)(class_3532.method_15349((double)velocityX, (double)velocityZ) * 57.2957763671875));
        }
        this.method_36457((float)(class_3532.method_15349((double)velocityY, (double)l) * 57.2957763671875));
        this.method_36457(InkProjectileEntity.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(InkProjectileEntity.method_26960((float)this.field_5982, (float)this.method_36454()));
        if (this.method_5799()) {
            for (int o = 0; o < 4; ++o) {
                this.field_6002.method_8406((class_2394)class_2398.field_11247, h - velocityX * 0.25, j - velocityY * 0.25, k - velocityZ * 0.25, velocityX, velocityY, velocityZ);
            }
        }
        this.method_5814(h, j, k);
        this.method_5852();
    }

    protected void age() {
        ++this.life;
        if (this.life >= 200) {
            this.method_31472();
        }
    }

    public boolean isNoClip() {
        if (!this.field_6002.field_9236) {
            return this.field_5960;
        }
        return true;
    }

    private void spawnParticles(int amount) {
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1 && amount > 0) {
            class_1767 dyeColor = class_1767.method_7791((int)colorOrdinal);
            class_1160 inkColor = InkColor.of(dyeColor).getColor();
            for (int j = 0; j < amount; ++j) {
                this.field_6002.method_8406((class_2394)SpectrumParticleTypes.getCraftingParticle(dyeColor), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), (double)inkColor.method_4943(), (double)inkColor.method_4945(), (double)inkColor.method_4947());
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        ColorHelper.tryColorEntity(null, entity, this.getDyeColor());
        float velocity = (float)this.method_18798().method_1033();
        int damage = class_3532.method_15384((double)class_3532.method_15350((double)((double)velocity * 0.5 * 2.0), (double)0.0, (double)2.147483647E9));
        class_1297 entity2 = this.method_24921();
        if (entity2 == null) {
            damageSource = SpectrumDamageSources.inkProjectile(this, (class_1297)this);
        } else {
            damageSource = SpectrumDamageSources.inkProjectile(this, entity2);
            if (entity2 instanceof class_1309) {
                ((class_1309)entity2).method_6114(entity);
            }
        }
        if (entity.method_5643(damageSource, (float)damage)) {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!this.field_6002.field_9236 && entity2 instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingEntity, (class_1297)entity2);
                    class_1890.method_8213((class_1309)((class_1309)entity2), (class_1297)livingEntity);
                }
                this.onHit(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof class_1657 && entity2 instanceof class_3222 && !this.method_5701()) {
                    ((class_3222)entity2).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
                if (!this.field_6002.field_9236 && entity2 instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity2;
                    if (!entity.method_5805()) {
                        SpectrumAdvancementCriteria.KILLED_BY_INK_PROJECTILE.trigger(serverPlayerEntity, Arrays.asList(entity));
                    }
                }
            }
            this.method_5783(this.getHitSound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            this.method_31472();
        } else {
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.field_6002.field_9236 && this.method_18798().method_1027() < 1.0E-7) {
                this.method_31472();
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        class_243 vec3d = blockHitResult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3d);
        class_243 vec3d2 = vec3d.method_1029().method_1021((double)0.05f);
        this.method_23327(this.method_23317() - vec3d2.field_1352, this.method_23318() - vec3d2.field_1351, this.method_23321() - vec3d2.field_1350);
        this.method_5783(this.getHitSound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1) {
            class_1767 dyeColor = class_1767.method_7791((int)colorOrdinal);
            for (class_2338 blockPos : class_2338.method_25996((class_2338)blockHitResult.method_17777(), (int)2, (int)2, (int)2)) {
                class_2248 coloredBlock = BlockVariantHelper.getCursedBlockColorVariant(this.field_6002, blockPos, dyeColor);
                if (coloredBlock == class_2246.field_10124) continue;
                this.field_6002.method_8501(blockPos, coloredBlock.method_9564());
            }
            this.affectEntitiesInRange(this.method_24921());
        }
        this.method_31472();
    }

    protected class_3414 getHitSound() {
        return SpectrumSoundEvents.INK_PROJECTILE_HIT;
    }

    @Nullable
    protected class_3966 getEntityCollision(class_243 currentPosition, class_243 nextPosition) {
        return class_1675.method_18077((class_1937)this.field_6002, (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    protected void onHit(class_1309 target) {
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1) {
            class_1309 entity = target;
            class_243 vec3d = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(1.7999999999999998);
            if (vec3d.method_1027() > 0.0) {
                entity.method_5762(vec3d.field_1352, 0.1, vec3d.field_1350);
            }
            this.affectEntitiesInRange(this.method_24921());
        }
        this.method_31472();
    }

    public void affectEntitiesInRange(class_1297 attacker) {
        this.field_6002.method_33596((class_1297)this, class_5712.field_28162, new class_2338(this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350));
        double posX = this.method_19538().field_1352;
        double posY = this.method_19538().field_1351;
        double posZ = this.method_19538().field_1350;
        float q = 4.0f;
        double k = class_3532.method_15357((double)(posX - (double)q - 1.0));
        double l = class_3532.method_15357((double)(posX + (double)q + 1.0));
        int r = class_3532.method_15357((double)(posY - (double)q - 1.0));
        int s = class_3532.method_15357((double)(posY + (double)q + 1.0));
        int t = class_3532.method_15357((double)(posZ - (double)q - 1.0));
        int u = class_3532.method_15357((double)(posZ + (double)q + 1.0));
        List list = this.field_6002.method_8335((class_1297)this, new class_238(k, (double)r, (double)t, l, (double)s, (double)u));
        class_243 vec3d = new class_243(posX, posY, posZ);
        for (class_1297 entity : list) {
            double ac;
            double z;
            double y;
            double x;
            double aa;
            double w;
            ColorHelper.tryColorEntity(null, entity, this.getDyeColor());
            if (entity.method_5659() || !((w = Math.sqrt(entity.method_5707(vec3d)) / (double)q) <= 1.0) || (aa = Math.sqrt((x = entity.method_23317() - posX) * x + (y = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - posY) * y + (z = entity.method_23321() - posZ) * z)) == 0.0) continue;
            x /= aa;
            y /= aa;
            z /= aa;
            double ab = class_1927.method_17752((class_243)vec3d, (class_1297)entity);
            double ad = ac = (1.0 - w) * ab;
            if (entity instanceof class_1309) {
                ad = class_1900.method_8237((class_1309)((class_1309)entity), (double)ac);
            }
            entity.method_18799(entity.method_18798().method_1031(x * ad, y * ad, z * ad));
        }
    }
}

