/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import com.mojang.logging.LogUtils;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.fluid.SpectrumFluidBlock;
import de.dafuqs.spectrum.data_loaders.EntityFishingDataLoader;
import de.dafuqs.spectrum.enchantments.ExuberanceEnchantment;
import de.dafuqs.spectrum.enchantments.FoundryEnchantment;
import de.dafuqs.spectrum.entity.entity.FireproofItemEntity;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PlayerEntityAccessor;
import de.dafuqs.spectrum.items.tools.SpectrumFishingRodItem;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class SpectrumFishingBobberEntity
extends class_1676 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Integer> HOOK_ENTITY_ID = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CAUGHT_FISH = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ABLAZE = class_2945.method_12791(SpectrumFishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private final class_5819 velocityRandom = class_5819.method_43047();
    private boolean caughtFish;
    private int outOfOpenFluidTicks;
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inTheOpen = true;
    @Nullable
    private class_1297 hookedEntity;
    private State state = State.FLYING;
    protected final int luckOfTheSeaLevel;
    protected final int lureLevel;
    protected final int exuberanceLevel;
    protected final int bigCatchLevel;
    protected final boolean inventoryInsertion;
    public static final class_2960 LOOT_IDENTIFIER = SpectrumCommon.locate("gameplay/universal_fishing");

    public SpectrumFishingBobberEntity(class_1299 type, class_1937 world, int luckOfTheSeaLevel, int lureLevel, int exuberanceLevel, int bigCatchLevel, boolean inventoryInsertion, boolean ablaze) {
        super(type, world);
        this.field_5985 = true;
        this.luckOfTheSeaLevel = Math.max(0, luckOfTheSeaLevel);
        this.lureLevel = Math.max(0, lureLevel);
        this.exuberanceLevel = Math.max(0, exuberanceLevel);
        this.bigCatchLevel = Math.max(0, bigCatchLevel);
        this.inventoryInsertion = inventoryInsertion;
        this.method_5841().method_12778(ABLAZE, (Object)ablaze);
    }

    public SpectrumFishingBobberEntity(class_1299 entityType, class_1937 world) {
        this(entityType, world, 0, 0, 0, 0, false, false);
    }

    public SpectrumFishingBobberEntity(class_1299 entityType, class_1657 thrower, class_1937 world, int luckOfTheSeaLevel, int lureLevel, int exuberanceLevel, int bigCatchLevel, boolean inventoryInsertion, boolean ablaze) {
        this(entityType, world, luckOfTheSeaLevel, lureLevel, exuberanceLevel, bigCatchLevel, inventoryInsertion, ablaze);
        this.method_7432((class_1297)thrower);
        float f = thrower.method_36455();
        float g = thrower.method_36454();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d = thrower.method_23317() - (double)i * 0.3;
        double e = thrower.method_23320();
        double l = thrower.method_23321() - (double)h * 0.3;
        this.method_5808(d, e, l, g, f);
        class_243 vec3d = new class_243((double)(-i), (double)class_3532.method_15363((float)(-(k / j)), (float)-5.0f, (float)5.0f), (double)(-h));
        double m = vec3d.method_1033();
        vec3d = vec3d.method_18805(0.6 / m + 0.5 + this.field_5974.method_43059() * 0.0045, 0.6 / m + 0.5 + this.field_5974.method_43059() * 0.0045, 0.6 / m + 0.5 + this.field_5974.method_43059() * 0.0045);
        this.method_18799(vec3d);
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public boolean method_5640(double distance) {
        return distance < 4096.0;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
    }

    public boolean isAblaze() {
        return (Boolean)this.method_5841().method_12789(ABLAZE);
    }

    public boolean method_5862() {
        return this.isAblaze();
    }

    protected void method_5693() {
        this.method_5841().method_12784(HOOK_ENTITY_ID, (Object)0);
        this.method_5841().method_12784(CAUGHT_FISH, (Object)false);
        this.method_5841().method_12784(ABLAZE, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (HOOK_ENTITY_ID.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(HOOK_ENTITY_ID);
            class_1297 class_12972 = this.hookedEntity = i > 0 ? this.field_6002.method_8469(i - 1) : null;
        }
        if (CAUGHT_FISH.equals(data)) {
            this.caughtFish = (Boolean)this.method_5841().method_12789(CAUGHT_FISH);
            if (this.caughtFish) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.velocityRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        super.method_5674(data);
    }

    public void method_5773() {
        super.method_5773();
        this.velocityRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.field_6002.method_8510());
        class_1657 playerEntity = this.getPlayerOwner();
        if (playerEntity == null) {
            this.method_31472();
        } else if (this.field_6002.field_9236 || !this.removeIfInvalid(playerEntity)) {
            boolean bl;
            SpectrumFishingRodItem spectrumFishingRodItem;
            if (this.field_5952) {
                ++this.removalTimer;
                if (this.removalTimer >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.removalTimer = 0;
            }
            float f = 0.0f;
            class_2338 blockPos = this.method_24515();
            class_3610 fluidState = this.field_6002.method_8316(blockPos);
            class_1799 rodStack = this.getFishingRod(playerEntity);
            boolean canFishInFluid = false;
            class_1792 class_17922 = rodStack.method_7909();
            if (class_17922 instanceof SpectrumFishingRodItem && (spectrumFishingRodItem = (SpectrumFishingRodItem)class_17922).canFishIn(fluidState)) {
                canFishInFluid = true;
                f = fluidState.method_15763((class_1922)this.field_6002, blockPos);
            }
            boolean bl2 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (this.hookedEntity != null) {
                    this.method_18799(class_243.field_1353);
                    this.state = State.HOOKED_IN_ENTITY;
                    this.onHookedEntity(this.hookedEntity);
                    return;
                }
                if (bl) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.state = State.BOBBING;
                    return;
                }
                this.method_7488(class_1675.method_18074((class_1297)this, this::method_26958));
            } else {
                if (this.state == State.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.method_31481() && this.hookedEntity.field_6002.method_27983() == this.field_6002.method_27983()) {
                            this.method_5814(this.hookedEntity.method_23317(), this.hookedEntity.method_23323(0.8), this.hookedEntity.method_23321());
                            this.hookedEntityTick(this.hookedEntity);
                        } else {
                            this.updateHookedEntityId(null);
                            this.state = State.FLYING;
                        }
                    }
                    return;
                }
                if (this.state == State.BOBBING) {
                    class_243 vec3d = this.method_18798();
                    double d = this.method_23318() + vec3d.field_1351 - (double)blockPos.method_10264() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.method_18800(vec3d.field_1352 * 0.9, vec3d.field_1351 - d * (double)this.field_5974.method_43057() * 0.2, vec3d.field_1350 * 0.9);
                    if (this.hookCountdown <= 0 && this.fishTravelCountdown <= 0) {
                        this.inTheOpen = true;
                    } else {
                        boolean bl3 = this.inTheOpen = this.inTheOpen && this.outOfOpenFluidTicks < 10 && this.isInTheOpen(blockPos);
                    }
                    if (bl) {
                        this.outOfOpenFluidTicks = Math.max(0, this.outOfOpenFluidTicks - 1);
                        if (this.caughtFish) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.velocityRandom.method_43057() * (double)this.velocityRandom.method_43057(), 0.0));
                        }
                        if (!this.field_6002.field_9236) {
                            this.tickFishingLogic(blockPos);
                        }
                    } else {
                        this.outOfOpenFluidTicks = Math.min(10, this.outOfOpenFluidTicks + 1);
                    }
                }
            }
            if (!canFishInFluid) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_26962();
            if (this.state == State.FLYING && (this.field_5952 || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            this.method_18799(this.method_18798().method_1021(0.92));
            this.method_23311();
        }
    }

    protected void onHookedEntity(class_1297 hookedEntity) {
    }

    protected void hookedEntityTick(class_1297 hookedEntity) {
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5822() {
        return false;
    }

    public class_1799 getFishingRod(class_1657 player) {
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7909() instanceof SpectrumFishingRodItem) {
            return itemStack;
        }
        itemStack = player.method_6079();
        if (itemStack.method_7909() instanceof SpectrumFishingRodItem) {
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public boolean removeIfInvalid(class_1657 player) {
        class_1799 rodStack = this.getFishingRod(player);
        if (!player.method_31481() && player.method_5805() && !rodStack.method_7960() && !(this.method_5858((class_1297)player) > 1024.0)) {
            return false;
        }
        this.method_31472();
        return true;
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    public void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.field_6002.field_9236) {
            class_1297 hookedEntity = entityHitResult.method_17782();
            this.updateHookedEntityId(hookedEntity);
        }
    }

    public void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_18799(this.method_18798().method_1029().method_1021(blockHitResult.method_24801((class_1297)this)));
    }

    public void updateHookedEntityId(@Nullable class_1297 entity) {
        this.hookedEntity = entity;
        this.method_5841().method_12778(HOOK_ENTITY_ID, (Object)(entity == null ? 0 : entity.method_5628() + 1));
    }

    public void tickFishingLogic(class_2338 pos) {
        class_3218 serverWorld = (class_3218)this.field_6002;
        int i = 1;
        class_2338 blockPos = pos.method_10084();
        if (this.field_5974.method_43057() < 0.25f && this.field_6002.method_8520(blockPos)) {
            ++i;
        }
        if (this.field_5974.method_43057() < 0.5f && !this.field_6002.method_8311(blockPos)) {
            --i;
        }
        if (this.hookCountdown > 0) {
            --this.hookCountdown;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.method_5841().method_12778(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            double j;
            double e;
            this.fishTravelCountdown -= i;
            this.fishAngle += (float)(this.field_5974.method_43059() * 4.0);
            float f = this.fishAngle * ((float)Math.PI / 180);
            float g = class_3532.method_15374((float)f);
            float h = class_3532.method_15362((float)f);
            double d = this.method_23317() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
            class_2680 blockState = serverWorld.method_8320(new class_2338(d, (e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0, j = this.method_23321() + (double)(h * (float)this.fishTravelCountdown * 0.1f)));
            class_3545<class_2400, class_2400> particles = this.getFluidParticles(blockState);
            if (particles != null) {
                if (this.fishTravelCountdown > 0) {
                    if (this.field_5974.method_43057() < 0.15f) {
                        serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), d, e - (double)0.1f, j, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), d, e, j, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), d, e, j, 0, (double)(-l), 0.01, (double)k, 1.0);
                } else {
                    this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                    double m = this.method_23318() + 0.5;
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15441()), this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                    this.hookCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                    this.method_5841().method_12778(CAUGHT_FISH, (Object)true);
                }
            }
        } else if (this.waitCountdown > 0) {
            this.waitCountdown -= i;
            float f = 0.15f;
            if (this.waitCountdown < 20) {
                f += (float)(20 - this.waitCountdown) * 0.05f;
            } else if (this.waitCountdown < 40) {
                f += (float)(40 - this.waitCountdown) * 0.02f;
            } else if (this.waitCountdown < 60) {
                f += (float)(60 - this.waitCountdown) * 0.01f;
            }
            if (this.field_5974.method_43057() < f) {
                double j;
                double e;
                float g = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double d = this.method_23317() + (double)(class_3532.method_15374((float)g) * h) * 0.1;
                class_2680 blockState = serverWorld.method_8320(new class_2338(d, (e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0, j = this.method_23321() + (double)(class_3532.method_15362((float)g) * h) * 0.1));
                class_3545<class_2400, class_2400> particles = this.getFluidParticles(blockState);
                if (particles != null) {
                    serverWorld.method_14199((class_2394)((class_2400)particles.method_15442()), d, e, j, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.waitCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)100, (int)600);
            this.waitCountdown -= this.lureLevel * 20 * 5;
            this.waitCountdown = Math.max(1, this.waitCountdown);
        }
    }

    @Nullable
    private class_3545<class_2400, class_2400> getFluidParticles(class_2680 blockState) {
        class_3545 particles = null;
        class_2248 class_22482 = this.field_6002.method_8320(this.method_24515()).method_26204();
        if (class_22482 instanceof SpectrumFluidBlock) {
            SpectrumFluidBlock spectrumFluidBlock = (SpectrumFluidBlock)class_22482;
            particles = spectrumFluidBlock.getFishingParticles();
        } else if (blockState.method_27852(class_2246.field_10164)) {
            particles = new class_3545((Object)class_2398.field_11240, (Object)SpectrumParticleTypes.LAVA_FISHING);
        } else if (blockState.method_27852(class_2246.field_10382)) {
            particles = new class_3545((Object)class_2398.field_11247, (Object)class_2398.field_11244);
        }
        return particles;
    }

    public boolean isInTheOpen(class_2338 pos) {
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            PositionType positionType2 = this.getPositionType(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
            switch (positionType2) {
                case INVALID: {
                    return false;
                }
                case ABOVE_FLUID: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case INSIDE_FLUID: {
                    if (positionType != PositionType.ABOVE_FLUID) break;
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    public PositionType getPositionType(class_2338 start, class_2338 end) {
        return class_2338.method_20437((class_2338)start, (class_2338)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
    }

    public PositionType getPositionType(class_2338 pos) {
        class_2680 blockState = this.field_6002.method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return !fluidState.method_15769() && fluidState.method_15771() && blockState.method_26220((class_1922)this.field_6002, pos).method_1110() ? PositionType.INSIDE_FLUID : PositionType.INVALID;
        }
        return PositionType.ABOVE_FLUID;
    }

    public boolean isInTheOpen() {
        return this.inTheOpen;
    }

    public int use(class_1799 usedItem) {
        class_1657 playerEntity = this.getPlayerOwner();
        if (!this.field_6002.field_9236 && playerEntity != null && !this.removeIfInvalid(playerEntity)) {
            int i = 0;
            if (this.hookedEntity != null) {
                this.pullHookedEntity(this.hookedEntity);
                SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, null, Collections.emptyList());
                this.field_6002.method_8421((class_1297)this, (byte)31);
                i = this.hookedEntity instanceof class_1542 ? 3 : 5;
            } else if (this.hookCountdown > 0) {
                if (!this.tryCatchEntity(usedItem, playerEntity, (class_3218)this.field_6002, this.method_24515())) {
                    this.catchLoot(usedItem, playerEntity);
                }
                i = 1;
            }
            if (this.field_5952) {
                i = 2;
            }
            this.method_31472();
            return i;
        }
        return 0;
    }

    private boolean tryCatchEntity(class_1799 usedItem, class_1657 playerEntity, class_3218 world, class_2338 blockPos) {
        Optional<class_1299> catchedEntityType = EntityFishingDataLoader.tryCatchEntity(world, blockPos, this.bigCatchLevel);
        if (catchedEntityType.isPresent()) {
            class_1297 entity = catchedEntityType.get().method_5899(world, null, null, playerEntity, blockPos, class_3730.field_16461, false, false);
            if (entity != null) {
                double xDif = playerEntity.method_23317() - this.method_23317();
                double yDif = playerEntity.method_23318() - this.method_23318();
                double zDif = playerEntity.method_23321() - this.method_23321();
                double velocityMod = 0.15;
                entity.method_18800(xDif * velocityMod, yDif * velocityMod + Math.sqrt(Math.sqrt(xDif * xDif + yDif * yDif + zDif * zDif)) * 0.08, zDif * velocityMod);
                if (this.isAblaze()) {
                    entity.method_5639(4);
                }
                if (entity instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)entity;
                    mobEntity.method_5966();
                    mobEntity.method_5990();
                }
                SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, entity, List.of());
            }
            return entity != null;
        }
        return false;
    }

    protected void catchLoot(class_1799 usedItem, class_1657 playerEntity) {
        class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(class_181.field_1229, (Object)usedItem).method_312(class_181.field_1226, (Object)this).method_311(this.field_5974).method_303((float)this.luckOfTheSeaLevel + playerEntity.method_7292());
        class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(LOOT_IDENTIFIER);
        Object list = lootTable.method_319(builder.method_309(class_173.field_1176));
        SpectrumAdvancementCriteria.FISHING_ROD_HOOKED.trigger((class_3222)playerEntity, usedItem, this, null, (Collection<class_1799>)list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (!itemStack.method_31573(class_3489.field_15527)) continue;
            playerEntity.method_7339(class_3468.field_15391, 1);
        }
        if (this.isAblaze()) {
            list = FoundryEnchantment.applyAutoSmelt(this.field_6002, (List<class_1799>)list);
        }
        float exuberanceMod = ExuberanceEnchantment.getExuberanceMod(this.exuberanceLevel);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            class_1799 itemStack = (class_1799)iterator2.next();
            int experienceAmount = this.field_5974.method_43048((int)(6.0f * exuberanceMod) + 1);
            if (this.inventoryInsertion) {
                Support.givePlayer(playerEntity, itemStack);
                playerEntity.method_7255(experienceAmount);
                continue;
            }
            FireproofItemEntity itemEntity = new FireproofItemEntity(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
            double d = playerEntity.method_23317() - this.method_23317();
            double e = playerEntity.method_23318() - this.method_23318();
            double f = playerEntity.method_23321() - this.method_23321();
            double g = 0.1;
            itemEntity.method_18800(d * g, e * g + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * g);
            this.field_6002.method_8649((class_1297)itemEntity);
            if (experienceAmount <= 0) continue;
            playerEntity.field_6002.method_8649((class_1297)new class_1303(playerEntity.field_6002, playerEntity.method_23317(), playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, experienceAmount));
        }
    }

    public void method_5711(byte status) {
        class_1657 player;
        class_1297 class_12972;
        if (status == 31 && this.field_6002.field_9236 && (class_12972 = this.hookedEntity) instanceof class_1657 && (player = (class_1657)class_12972).method_7340()) {
            this.pullHookedEntity((class_1297)player);
        }
        super.method_5711(status);
    }

    public void pullHookedEntity(class_1297 entity) {
        class_1297 owner = this.method_24921();
        if (owner != null) {
            class_243 vec3d = new class_243(owner.method_23317() - this.method_23317(), owner.method_23318() - this.method_23318(), owner.method_23321() - this.method_23321()).method_1021(0.1);
            entity.method_18799(entity.method_18798().method_1019(vec3d));
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.setPlayerFishHook(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.setPlayerFishHook(null);
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        this.setPlayerFishHook(this);
    }

    public void setPlayerFishHook(@Nullable SpectrumFishingBobberEntity fishingBobber) {
        class_1657 playerEntity = this.getPlayerOwner();
        if (playerEntity != null) {
            ((PlayerEntityAccessor)playerEntity).setSpectrumBobber(fishingBobber);
        }
    }

    @Nullable
    public class_1657 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1657 ? (class_1657)entity : null;
    }

    @Nullable
    public class_1297 getHookedEntity() {
        return this.hookedEntity;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getPlayerOwner() == null) {
            int entityData = packet.method_11166();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.field_6002.method_8469(entityData), (Object)entityData);
            this.method_5768();
        }
    }

    protected static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    protected static enum PositionType {
        ABOVE_FLUID,
        INSIDE_FLUID,
        INVALID;

    }
}

