/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.enums;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.GemstoneColor;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum PedestalRecipeTier {
    BASIC,
    SIMPLE,
    ADVANCED,
    COMPLEX;


    @Contract(pure=true)
    public static GemstoneColor[] getAvailableGemstoneDustColors(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                return BuiltinGemstoneColor.values();
            }
            case ADVANCED: {
                return new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW, BuiltinGemstoneColor.BLACK};
            }
        }
        return new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW};
    }

    @Contract(pure=true)
    public static Optional<PedestalRecipeTier> getHighestUnlockedRecipeTier(class_1657 playerEntity) {
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("lategame/build_complex_pedestal_structure"))) {
            return Optional.of(COMPLEX);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("midgame/build_advanced_pedestal_structure"))) {
            return Optional.of(ADVANCED);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("build_basic_pedestal_structure"))) {
            return Optional.of(SIMPLE);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("place_pedestal"))) {
            return Optional.of(BASIC);
        }
        return Optional.empty();
    }

    public static boolean hasUnlockedRequiredTier(class_1657 playerEntity, @NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case BASIC: {
                return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("place_pedestal"));
            }
            case SIMPLE: {
                return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("build_basic_pedestal_structure"));
            }
            case ADVANCED: {
                return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("midgame/build_advanced_pedestal_structure"));
            }
            case COMPLEX: {
                return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)SpectrumCommon.locate("lategame/build_complex_pedestal_structure"));
            }
        }
        return false;
    }

    public static Optional<PedestalRecipeTier> hasJustUnlockedANewRecipeTier(@NotNull class_2960 advancementIdentifier) {
        if (advancementIdentifier.equals((Object)SpectrumCommon.locate("place_pedestal"))) {
            return Optional.of(BASIC);
        }
        if (advancementIdentifier.equals((Object)SpectrumCommon.locate("build_basic_pedestal_structure"))) {
            return Optional.of(SIMPLE);
        }
        if (advancementIdentifier.equals((Object)SpectrumCommon.locate("midgame/build_advanced_pedestal_structure"))) {
            return Optional.of(ADVANCED);
        }
        if (advancementIdentifier.equals((Object)SpectrumCommon.locate("lategame/build_complex_pedestal_structure"))) {
            return Optional.of(COMPLEX);
        }
        return Optional.empty();
    }
}

