/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.graces.crystal;

import com.google.common.collect.ImmutableSet;

public enum ColorPool {
    BLACK(new ColorPool[0]),
    WHITE(new ColorPool[0]),
    GREY(BLACK, WHITE),
    LIGHT_GREY(GREY, WHITE),
    CYAN(new ColorPool[0]),
    MAGENTA(new ColorPool[0]),
    YELLOW(new ColorPool[0]),
    RED(MAGENTA, YELLOW),
    BLUE(MAGENTA, CYAN),
    GREEN(CYAN, YELLOW),
    PINK(RED, WHITE),
    LIGHT_BLUE(BLUE, WHITE),
    LIME(GREEN, YELLOW),
    ORANGE(RED, YELLOW),
    PURPLE(BLUE, MAGENTA),
    BROWN(ORANGE, BLACK),
    CHROMATIC(BLACK, WHITE, GREY, LIGHT_GREY, CYAN, MAGENTA, YELLOW, RED, BLUE, GREEN, PINK, LIGHT_BLUE, LIME, ORANGE, PURPLE, BROWN),
    MURKY(new ColorPool[0]);

    public final ImmutableSet<ColorPool> componentSet;

    private ColorPool(ColorPool ... components) {
        ImmutableSet.Builder componentBuilder = ImmutableSet.builder();
        componentBuilder.add((Object[])components);
        this.componentSet = componentBuilder.build();
    }

    public boolean rejects(ColorPool other) {
        return switch (this) {
            case WHITE -> {
                if (other == BLACK) {
                    yield true;
                }
                yield false;
            }
            case BLACK -> {
                if (other == WHITE) {
                    yield true;
                }
                yield false;
            }
            case CYAN -> {
                if (other == ORANGE) {
                    yield true;
                }
                yield false;
            }
            case MAGENTA -> {
                if (other == GREEN) {
                    yield true;
                }
                yield false;
            }
            case YELLOW -> {
                if (other == BLUE) {
                    yield true;
                }
                yield false;
            }
            case BLUE -> {
                if (other == YELLOW || other == ORANGE) {
                    yield true;
                }
                yield false;
            }
            case GREEN -> {
                if (other == MAGENTA || other == PURPLE) {
                    yield true;
                }
                yield false;
            }
            case ORANGE -> {
                if (other == CYAN || other == BLUE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean synergizes(ColorPool target) {
        return target == this;
    }
}

