/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class BuildingHelper {
    private static final Map<class_2248, class_2248> SIMILAR_BLOCKS = new HashMap<class_2248, class_2248>(){
        {
            this.put(class_2246.field_10566, class_2246.field_10219);
            this.put(class_2246.field_10219, class_2246.field_10566);
            this.put(class_2246.field_10520, class_2246.field_10566);
            this.put(class_2246.field_10402, class_2246.field_10566);
            this.put(class_2246.field_10253, class_2246.field_10566);
            this.put(class_2246.field_10277, class_2246.field_10340);
            this.put(class_2246.field_10387, class_2246.field_10340);
            this.put(class_2246.field_10480, class_2246.field_10065);
            this.put(class_2246.field_10176, class_2246.field_10552);
            this.put(class_2246.field_10492, class_2246.field_10445);
            this.put(class_2246.field_10100, class_2246.field_10416);
            this.put(class_2246.field_29224, class_2246.field_28888);
        }
    };
    private static final ArrayList<class_2382> NEIGHBOR_VECTORS_Y = new ArrayList<class_2382>(){
        {
            this.add(class_2350.field_11043.method_10163());
            this.add(class_2350.field_11034.method_10163());
            this.add(class_2350.field_11035.method_10163());
            this.add(class_2350.field_11039.method_10163());
            this.add(class_2350.field_11039.method_10163().method_23226(class_2350.field_11043, 1));
            this.add(class_2350.field_11043.method_10163().method_23226(class_2350.field_11034, 1));
            this.add(class_2350.field_11034.method_10163().method_23226(class_2350.field_11035, 1));
            this.add(class_2350.field_11035.method_10163().method_23226(class_2350.field_11039, 1));
        }
    };

    public static Triplet<class_2248, class_1792, Integer> getBuildingItemCountInInventoryIncludingSimilars(class_1657 player, class_2248 block) {
        class_1792 blockItem = block.method_8389();
        if (blockItem instanceof class_1798) {
            return new Triplet((Object)block, (Object)blockItem, (Object)0);
        }
        int count = player.method_31548().method_18861(block.method_8389());
        if (count == 0 && SIMILAR_BLOCKS.containsKey(block)) {
            class_2248 similarBlock = SIMILAR_BLOCKS.get(block);
            class_1792 similarBlockItem = similarBlock.method_8389();
            int similarCount = player.method_31548().method_18861(similarBlockItem);
            if (similarCount > 0) {
                return new Triplet((Object)similarBlock, (Object)similarBlockItem, (Object)similarCount);
            }
        }
        return new Triplet((Object)block, (Object)blockItem, (Object)count);
    }

    @NotNull
    public static List<class_2338> getConnectedBlocks(@NotNull class_1937 world, @NotNull class_2338 blockPos, int maxCount, int maxRange) {
        class_2338 currentPos;
        class_2680 originState = world.method_8320(blockPos);
        class_2248 originBlock = originState.method_26204();
        ArrayList<class_2338> connectedPositions = new ArrayList<class_2338>();
        ArrayList<class_2338> visitedPositions = new ArrayList<class_2338>();
        LinkedList<class_2338> positionsToVisit = new LinkedList<class_2338>();
        connectedPositions.add(blockPos);
        visitedPositions.add(blockPos);
        positionsToVisit.add(blockPos);
        block0: while (connectedPositions.size() < maxCount && (currentPos = (class_2338)positionsToVisit.poll()) != null) {
            for (class_2350 direction : class_2350.values()) {
                class_2248 localBlock;
                class_2338 offsetPos = currentPos.method_10093(direction);
                if (visitedPositions.contains(offsetPos)) continue;
                visitedPositions.add(offsetPos);
                if (!blockPos.method_19771((class_2382)offsetPos, (double)maxRange) || !(localBlock = world.method_8320(offsetPos).method_26204()).equals(originBlock) && (!SIMILAR_BLOCKS.containsKey(localBlock) || !SIMILAR_BLOCKS.get(localBlock).equals(originBlock))) continue;
                positionsToVisit.add(offsetPos);
                connectedPositions.add(offsetPos);
                if (connectedPositions.size() >= maxCount) continue block0;
            }
        }
        return connectedPositions;
    }

    @NotNull
    public static List<class_2338> calculateBuildingStaffSelection(@NotNull class_1937 world, @NotNull class_2338 originPos, class_2350 direction, int maxCount, int maxRange, boolean sameBlockOnly) {
        class_2338 offsetPos = originPos.method_10093(direction);
        class_2680 originState = world.method_8320(originPos);
        ArrayList<class_2338> selectedPositions = new ArrayList<class_2338>();
        int count = 1;
        ArrayList<Object> storedNeighbors = new ArrayList<Object>();
        if (world.method_8628(originState, offsetPos, class_3726.method_16194())) {
            storedNeighbors.add(offsetPos);
        }
        while (count < maxCount && !storedNeighbors.isEmpty()) {
            selectedPositions.addAll(storedNeighbors);
            ArrayList<class_2338> newNeighbors = new ArrayList<class_2338>();
            for (class_2338 class_23382 : storedNeighbors) {
                List<class_2338> facingNeighbors = BuildingHelper.getValidNeighbors(world, class_23382, direction, originState, sameBlockOnly);
                for (class_2338 facingNeighbor : facingNeighbors) {
                    if (count >= maxCount || !originPos.method_19771((class_2382)facingNeighbor, (double)maxRange) || selectedPositions.contains(facingNeighbor) || storedNeighbors.contains(facingNeighbor) || newNeighbors.contains(facingNeighbor)) continue;
                    newNeighbors.add(facingNeighbor);
                    ++count;
                }
            }
            storedNeighbors.clear();
            storedNeighbors.addAll(newNeighbors);
        }
        selectedPositions.addAll(storedNeighbors);
        return selectedPositions;
    }

    @NotNull
    private static List<class_2338> getValidNeighbors(class_1937 world, class_2338 startPos, class_2350 facingDirection, class_2680 originState, boolean sameBlockOnly) {
        ArrayList<class_2338> foundNeighbors = new ArrayList<class_2338>();
        for (class_2382 neighborVectors : BuildingHelper.getNeighborVectors(facingDirection)) {
            class_2338 targetPos = startPos.method_10081(neighborVectors);
            class_2680 targetState = world.method_8320(targetPos);
            class_2680 facingAgainstState = world.method_8320(targetPos.method_10093(facingDirection.method_10153()));
            if (!targetState.method_26207().method_15800() && targetState.method_26227().method_15769() || !world.method_8628(originState, targetPos, class_3726.method_16194())) continue;
            if (sameBlockOnly) {
                if (!facingAgainstState.equals(originState) && (!SIMILAR_BLOCKS.containsKey(facingAgainstState.method_26204()) || SIMILAR_BLOCKS.get(facingAgainstState.method_26204()) != originState.method_26204())) continue;
                foundNeighbors.add(targetPos);
                continue;
            }
            if (facingAgainstState.method_26215()) continue;
            foundNeighbors.add(targetPos);
        }
        return foundNeighbors;
    }

    @NotNull
    private static List<class_2382> getNeighborVectors(final @NotNull class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return NEIGHBOR_VECTORS_Y;
        }
        return new ArrayList<class_2382>(){
            {
                this.add(direction.method_10170().method_10163());
                this.add(direction.method_10160().method_10163());
                this.add(class_2350.field_11036.method_10163());
                this.add(class_2350.field_11033.method_10163());
            }
        };
    }
}

