/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.spectrum.entity.entity.EggLayingWoolyPigEntity;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.mixin.accessors.ShulkerEntityAccessor;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ColorHelper {
    public static class_1160 getVec(class_1767 dyeColor) {
        return switch (dyeColor) {
            case class_1767.field_7963 -> new class_1160(0.1f, 0.1f, 0.1f);
            case class_1767.field_7966 -> new class_1160(0.05f, 0.011f, 0.95f);
            case class_1767.field_7957 -> new class_1160(0.31f, 0.16f, 0.05f);
            case class_1767.field_7955 -> new class_1160(0.0f, 1.0f, 1.0f);
            case class_1767.field_7944 -> new class_1160(0.3f, 0.3f, 0.3f);
            case class_1767.field_7942 -> new class_1160(0.14f, 0.24f, 0.0f);
            case class_1767.field_7951 -> new class_1160(0.0f, 0.75f, 0.95f);
            case class_1767.field_7967 -> new class_1160(0.68f, 0.68f, 0.68f);
            case class_1767.field_7961 -> new class_1160(0.0f, 0.86f, 0.0f);
            case class_1767.field_7958 -> new class_1160(1.0f, 0.0f, 1.0f);
            case class_1767.field_7946 -> new class_1160(0.93f, 0.39f, 0.0f);
            case class_1767.field_7954 -> new class_1160(1.0f, 0.78f, 0.87f);
            case class_1767.field_7945 -> new class_1160(0.43f, 0.0f, 0.68f);
            case class_1767.field_7964 -> new class_1160(0.95f, 0.0f, 0.0f);
            case class_1767.field_7952 -> new class_1160(0.97f, 0.97f, 0.97f);
            default -> new class_1160(0.93f, 0.93f, 0.0f);
        };
    }

    public static int getInt(class_1767 dyeColor) {
        class_1160 vec = ColorHelper.getVec(dyeColor);
        return new Color(vec.method_4943(), vec.method_4945(), vec.method_4947()).getRGB();
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static Color colorFromRGB(int r, int g, int b) {
        return ColorHelper.colorFromRGBA(r, g, b, 255.0f);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static Color colorFromRGB(float r, float g, float b) {
        return ColorHelper.colorFromRGBA(r, g, b, 1.0f);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static Color colorFromRGBA(float r, float g, float b, float a) {
        return new Color((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
    }

    @NotNull
    public static class_1160 colorIntToVec(int color2) {
        Color colorValue2 = new Color(color2);
        float[] argb2 = new float[4];
        colorValue2.getColorComponents(argb2);
        return new class_1160(argb2[0], argb2[1], argb2[2]);
    }

    public static Optional<class_1767> getDyeColorOfItemStack(@NotNull class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            class_1792 item = itemStack.method_7909();
            if (item instanceof class_1769) {
                class_1769 dyeItem = (class_1769)item;
                return Optional.of(dyeItem.method_7802());
            }
            if (item instanceof PigmentItem) {
                PigmentItem pigmentItem = (PigmentItem)item;
                return Optional.of(pigmentItem.getColor());
            }
        }
        return Optional.empty();
    }

    public static boolean tryColorEntity(class_1657 user, class_1297 entity, class_1767 dyeColor) {
        class_1606 shulkerEntity;
        EggLayingWoolyPigEntity woolyPig;
        class_1472 sheepEntity;
        if (entity instanceof class_1472 && (sheepEntity = (class_1472)entity).method_5805() && !sheepEntity.method_6629()) {
            if (sheepEntity.method_6633() != dyeColor) {
                sheepEntity.field_6002.method_43129(user, (class_1297)sheepEntity, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                sheepEntity.method_6631(dyeColor);
                return true;
            }
        } else if (entity instanceof EggLayingWoolyPigEntity && (woolyPig = (EggLayingWoolyPigEntity)entity).method_5805() && !woolyPig.isSheared()) {
            if (woolyPig.getColor() != dyeColor) {
                woolyPig.field_6002.method_43129(user, (class_1297)woolyPig, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                woolyPig.setColor(dyeColor);
                return true;
            }
        } else if (entity instanceof class_1606 && (shulkerEntity = (class_1606)entity).method_5805() && shulkerEntity.method_7121() != dyeColor) {
            shulkerEntity.field_6002.method_43129(user, (class_1297)shulkerEntity, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
            ((ShulkerEntityAccessor)shulkerEntity).invokeSetColor(dyeColor);
            return true;
        }
        return false;
    }
}

