/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Support {
    public static final List<class_243> VECTORS_4 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(0.0, 0.0, -1.0));
        }
    };
    public static final List<class_243> VECTORS_8 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.7, 0.0, 0.7));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-0.7, 0.0, 0.7));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(-0.7, 0.0, -0.7));
            this.add(new class_243(0.0, 0.0, -1.0));
            this.add(new class_243(0.7, 0.0, -0.7));
        }
    };
    public static final List<class_243> VECTORS_8_OFFSET = new ArrayList<class_243>(){
        {
            this.add(new class_243(0.75, 0.0, 0.5));
            this.add(new class_243(0.5, 0.0, 0.75));
            this.add(new class_243(-0.5, 0.0, 0.75));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-0.5, 0.0, -0.75));
            this.add(new class_243(0.5, 0.0, -0.75));
            this.add(new class_243(0.75, 0.0, -0.5));
        }
    };
    public static final List<class_243> VECTORS_16 = new ArrayList<class_243>(){
        {
            this.add(new class_243(1.0, 0.0, 0.0));
            this.add(new class_243(0.75, 0.0, 0.5));
            this.add(new class_243(0.7, 0.0, 0.7));
            this.add(new class_243(0.5, 0.0, 0.75));
            this.add(new class_243(0.0, 0.0, 1.0));
            this.add(new class_243(-0.5, 0.0, 0.75));
            this.add(new class_243(-0.7, 0.0, 0.7));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-1.0, 0.0, 0.0));
            this.add(new class_243(-0.75, 0.0, 0.5));
            this.add(new class_243(-0.7, 0.0, -0.7));
            this.add(new class_243(-0.5, 0.0, -0.75));
            this.add(new class_243(0.0, 0.0, -1.0));
            this.add(new class_243(0.5, 0.0, -0.75));
            this.add(new class_243(0.7, 0.0, -0.7));
            this.add(new class_243(0.75, 0.0, -0.5));
        }
    };
    private static final class_2960 PROGRESSION_FINISHED_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("lategame/finish_progression");
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static final DecimalFormat df1 = new DecimalFormat("0.0");
    private static final DecimalFormat df2 = new DecimalFormat("0");

    @NotNull
    public static Optional<class_6862<class_2248>> getFirstMatchingBlockTag(@NotNull class_2680 blockState, @NotNull List<class_6862<class_2248>> tags) {
        return blockState.method_40144().filter(tags::contains).findFirst();
    }

    public static String getWithOneDecimalAfterComma(float number) {
        return df1.format(number);
    }

    public static String getShortenedNumberString(double number) {
        if (number > 1.0E9) {
            return df.format(number / 1.0E9) + "G";
        }
        if (number > 1000000.0) {
            return df.format(number / 1000000.0) + "M";
        }
        if (number > 1000.0) {
            return df.format(number / 1000.0) + "K";
        }
        return df2.format(number);
    }

    public static String getShortenedNumberString(long number) {
        if (number > 1000000000L) {
            return df.format((double)number / 1.0E9) + "G";
        }
        if (number > 1000000L) {
            return df.format((double)number / 1000000.0) + "M";
        }
        if (number > 1000L) {
            return df.format((double)number / 1000.0) + "K";
        }
        return df2.format(number);
    }

    public static String getSensiblePercent(long x, long y) {
        if (y == 0L) {
            return "0";
        }
        double result = (double)x / (double)y;
        if (result < 0.01 && x > 0L) {
            return "1";
        }
        if (result > 0.99 && x != y) {
            return "99";
        }
        return df2.format(Math.round(result * 100.0));
    }

    public static void givePlayer(class_1657 playerEntity, class_1799 itemStack) {
        boolean insertInventorySuccess = playerEntity.method_31548().method_7394(itemStack);
        if (insertInventorySuccess && itemStack.method_7960()) {
            itemStack.method_7939(1);
            class_1542 itemEntity = playerEntity.method_7328(itemStack, false);
            if (itemEntity != null) {
                itemEntity.method_6987();
            }
            playerEntity.field_6002.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((playerEntity.method_6051().method_43057() - playerEntity.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
            playerEntity.field_7512.method_7623();
        } else {
            class_1542 itemEntity = playerEntity.method_7328(itemStack, false);
            if (itemEntity != null) {
                itemEntity.method_6975();
                itemEntity.method_6984(playerEntity.method_5667());
            }
        }
    }

    public static int getIntFromDecimalWithChance(double d, @NotNull class_5819 random) {
        boolean roundUp;
        boolean bl = roundUp = (double)random.method_43057() < d % 1.0;
        if (roundUp) {
            return (int)d + 1;
        }
        return (int)d;
    }

    public static class_2338 directionalOffset(class_2338 origin, class_2382 forwardUpRight, @NotNull class_2350 horizontalFacing) {
        switch (horizontalFacing) {
            case field_11043: {
                return origin.method_10069(forwardUpRight.method_10260(), forwardUpRight.method_10264(), -forwardUpRight.method_10263());
            }
            case field_11034: {
                return origin.method_10069(forwardUpRight.method_10263(), forwardUpRight.method_10264(), forwardUpRight.method_10260());
            }
            case field_11035: {
                return origin.method_10069(-forwardUpRight.method_10260(), forwardUpRight.method_10264(), forwardUpRight.method_10263());
            }
            case field_11039: {
                return origin.method_10069(-forwardUpRight.method_10263(), forwardUpRight.method_10264(), -forwardUpRight.method_10260());
            }
        }
        SpectrumCommon.logWarning("Called directionalOffset with facing" + horizontalFacing + " this is not supported.");
        return origin;
    }

    public static void grantAdvancementCriterion(@NotNull class_3222 serverPlayerEntity, class_2960 advancementIdentifier, String criterion) {
        if (serverPlayerEntity.method_5682() == null) {
            return;
        }
        class_2989 sal = serverPlayerEntity.method_5682().method_3851();
        class_2985 tracker = serverPlayerEntity.method_14236();
        class_161 advancement = sal.method_12896(advancementIdentifier);
        if (advancement == null) {
            SpectrumCommon.logError("Trying to grant a criterion \"" + criterion + "\" for an advancement that does not exist: " + advancementIdentifier);
        } else if (!tracker.method_12882(advancement).method_740()) {
            tracker.method_12878(advancement, criterion);
        }
    }

    public static void grantAdvancementCriterion(@NotNull class_3222 serverPlayerEntity, String advancementString, String criterion) {
        Support.grantAdvancementCriterion(serverPlayerEntity, SpectrumCommon.locate(advancementString), criterion);
    }

    @NotNull
    public static String getReadableDimensionString(@NotNull String dimensionKeyString) {
        switch (dimensionKeyString) {
            case "minecraft:overworld": {
                return "Overworld";
            }
            case "minecraft:nether": {
                return "Nether";
            }
            case "minecraft:end": {
                return "End";
            }
        }
        if (dimensionKeyString.contains(":")) {
            return dimensionKeyString.substring(0, dimensionKeyString.indexOf(":"));
        }
        return dimensionKeyString;
    }

    @Contract(pure=true)
    public static class_2350 directionFromRotation(@NotNull class_2470 blockRotation) {
        switch (blockRotation) {
            case field_11467: {
                return class_2350.field_11034;
            }
            case field_11463: {
                return class_2350.field_11035;
            }
            case field_11464: {
                return class_2350.field_11039;
            }
        }
        return class_2350.field_11043;
    }

    @Contract(pure=true)
    public static class_2470 rotationFromDirection(@NotNull class_2350 direction) {
        switch (direction) {
            case field_11034: {
                return class_2470.field_11467;
            }
            case field_11035: {
                return class_2470.field_11463;
            }
            case field_11039: {
                return class_2470.field_11464;
            }
        }
        return class_2470.field_11465;
    }

    public static boolean hasPlayerFinishedMod(class_1657 player) {
        return AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)PROGRESSION_FINISHED_ADVANCEMENT_IDENTIFIER);
    }

    public static Optional<class_2338> getNexReplaceableBlockPosUpDown(class_1937 world, class_2338 blockPos, int maxUpDown) {
        if (world.method_8320(blockPos).method_26207().method_15800()) {
            for (int i = 0; i < maxUpDown; ++i) {
                if (world.method_8320(blockPos.method_10087(i + 1)).method_26207().method_15800()) continue;
                return Optional.of(blockPos.method_10087(i));
            }
        } else {
            for (int i = 1; i <= maxUpDown; ++i) {
                if (!world.method_8320(blockPos.method_10086(i)).method_26207().method_15800()) continue;
                return Optional.of(blockPos.method_10086(i));
            }
        }
        return Optional.empty();
    }

    public static double logBase(double base, double logNumber) {
        return Math.log(logNumber) / Math.log(base);
    }
}

