/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.inventories.CraftingTabletInventory;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import de.dafuqs.spectrum.inventories.slots.LockableCraftingResultSlot;
import de.dafuqs.spectrum.inventories.slots.ReadOnlySlot;
import de.dafuqs.spectrum.items.CraftingTabletItem;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5421;
import org.jetbrains.annotations.NotNull;

public class CraftingTabletScreenHandler
extends class_1729<class_1263> {
    private final CraftingTabletInventory craftingInventory = new CraftingTabletInventory((class_1703)this);
    private final class_1731 craftingResultInventory = new class_1731();
    private final class_3914 context;
    private final class_1657 player;
    private final class_1937 world;
    private final class_1799 craftingTabletItemStack;
    private final Optional<PedestalRecipeTier> highestUnlockedRecipeTier;
    private final LockableCraftingResultSlot lockableCraftingResultSlot;

    public CraftingTabletScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304, null);
    }

    public CraftingTabletScreenHandler(int syncId, class_1661 playerInventory, class_3914 context, class_1799 craftingTabletItemStack) {
        super(SpectrumScreenHandlerTypes.CRAFTING_TABLET, syncId);
        int l;
        this.context = context;
        this.world = playerInventory.field_7546.method_5770();
        this.craftingTabletItemStack = craftingTabletItemStack;
        this.player = playerInventory.field_7546;
        this.highestUnlockedRecipeTier = PedestalRecipeTier.getHighestUnlockedRecipeTier(playerInventory.field_7546);
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 3; ++n) {
                this.method_7621(new class_1735((class_1263)this.craftingInventory, n + m * 3, 30 + n * 18, 19 + m * 18));
            }
        }
        if (this.highestUnlockedRecipeTier.isPresent()) {
            switch (this.highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 9, 44, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 10, 62, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 11, 80, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 12, 98, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 13, 116, 77));
                    break;
                }
                case ADVANCED: {
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 9, 53, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 10, 71, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 11, 89, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 12, 107, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 13, -2000, 77));
                    break;
                }
                default: {
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 9, 62, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 10, 80, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 11, 98, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 12, -2000, 77));
                    this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 13, -2000, 77));
                    break;
                }
            }
        } else {
            this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 9, 62, 77));
            this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 10, 80, 77));
            this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 11, 98, 77));
            this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 12, -2000, 77));
            this.method_7621(new ReadOnlySlot((class_1263)this.craftingInventory, 13, -2000, 77));
        }
        this.lockableCraftingResultSlot = new LockableCraftingResultSlot((class_1263)this.craftingResultInventory, 0, 127, 37, playerInventory.field_7546, this.craftingInventory, 0, 8);
        this.method_7621((class_1735)this.lockableCraftingResultSlot);
        for (l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(new class_1735((class_1263)playerInventory, k + l * 9 + 9, 8 + k * 18, 112 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.method_7621(new class_1735((class_1263)playerInventory, l, 8 + l * 18, 170));
        }
    }

    protected void updateResult(class_1703 handler, @NotNull class_1937 world, class_1657 player, CraftingTabletInventory inventory) {
        if (!world.field_9236) {
            class_3222 serverPlayerEntity = (class_3222)player;
            inventory.method_5447(9, new class_1799((class_1935)SpectrumItems.TOPAZ_POWDER, 64));
            inventory.method_5447(10, new class_1799((class_1935)SpectrumItems.AMETHYST_POWDER, 64));
            inventory.method_5447(11, new class_1799((class_1935)SpectrumItems.CITRINE_POWDER, 64));
            inventory.method_5447(12, new class_1799((class_1935)SpectrumItems.ONYX_POWDER, 64));
            inventory.method_5447(13, new class_1799((class_1935)SpectrumItems.MOONSTONE_POWDER, 64));
            Optional optionalPedestalCraftingRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.PEDESTAL, (class_1263)inventory, world);
            if (optionalPedestalCraftingRecipe.isPresent()) {
                this.lockableCraftingResultSlot.lock();
                PedestalCraftingRecipe pedestalCraftingRecipe = (PedestalCraftingRecipe)optionalPedestalCraftingRecipe.get();
                class_1799 itemStack = pedestalCraftingRecipe.method_8110().method_7972();
                this.craftingResultInventory.method_5447(0, itemStack);
                int magenta = pedestalCraftingRecipe.getGemstonePowderAmount(BuiltinGemstoneColor.CYAN);
                if (magenta > 0) {
                    inventory.method_5447(9, new class_1799((class_1935)SpectrumItems.TOPAZ_POWDER, magenta));
                } else {
                    inventory.method_5447(9, class_1799.field_8037);
                }
                int yellow = pedestalCraftingRecipe.getGemstonePowderAmount(BuiltinGemstoneColor.MAGENTA);
                if (yellow > 0) {
                    inventory.method_5447(10, new class_1799((class_1935)SpectrumItems.AMETHYST_POWDER, yellow));
                } else {
                    inventory.method_5447(10, class_1799.field_8037);
                }
                int cyan = pedestalCraftingRecipe.getGemstonePowderAmount(BuiltinGemstoneColor.YELLOW);
                if (cyan > 0) {
                    inventory.method_5447(11, new class_1799((class_1935)SpectrumItems.CITRINE_POWDER, cyan));
                } else {
                    inventory.method_5447(11, class_1799.field_8037);
                }
                int black = pedestalCraftingRecipe.getGemstonePowderAmount(BuiltinGemstoneColor.BLACK);
                if (black > 0) {
                    inventory.method_5447(12, new class_1799((class_1935)SpectrumItems.ONYX_POWDER, black));
                } else {
                    inventory.method_5447(12, class_1799.field_8037);
                }
                int white = pedestalCraftingRecipe.getGemstonePowderAmount(BuiltinGemstoneColor.WHITE);
                if (white > 0) {
                    inventory.method_5447(13, new class_1799((class_1935)SpectrumItems.MOONSTONE_POWDER, white));
                } else {
                    inventory.method_5447(13, class_1799.field_8037);
                }
                handler.method_34245(0, itemStack);
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37422(), 14, itemStack));
                CraftingTabletItem.setStoredRecipe(this.craftingTabletItemStack, (class_1860)optionalPedestalCraftingRecipe.get());
            } else {
                inventory.method_5447(9, class_1799.field_8037);
                inventory.method_5447(10, class_1799.field_8037);
                inventory.method_5447(11, class_1799.field_8037);
                inventory.method_5447(12, class_1799.field_8037);
                inventory.method_5447(13, class_1799.field_8037);
                class_1799 itemStack = class_1799.field_8037;
                Optional optionalCraftingRecipe = world.method_8433().method_8132(class_3956.field_17545, (class_1263)inventory, world);
                if (optionalCraftingRecipe.isPresent()) {
                    this.lockableCraftingResultSlot.unlock();
                    class_3955 craftingRecipe = (class_3955)optionalCraftingRecipe.get();
                    if (this.craftingResultInventory.method_7665(world, serverPlayerEntity, (class_1860)craftingRecipe)) {
                        itemStack = craftingRecipe.method_8116((class_1263)this.craftingInventory);
                    }
                    CraftingTabletItem.setStoredRecipe(this.craftingTabletItemStack, (class_1860)optionalCraftingRecipe.get());
                } else {
                    CraftingTabletItem.clearStoredRecipe(this.craftingTabletItemStack);
                }
                this.craftingResultInventory.method_5447(0, itemStack);
                handler.method_34245(0, itemStack);
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37422(), 14, itemStack));
            }
        }
    }

    public void method_7609(class_1263 inventory) {
        this.context.method_17393((world, pos) -> this.updateResult((class_1703)this, (class_1937)world, this.player, this.craftingInventory));
    }

    public void method_7654(class_1662 recipeMatcher) {
        if (this.craftingInventory != null) {
            this.craftingInventory.method_7683(recipeMatcher);
        }
    }

    public void method_7657() {
        this.craftingInventory.method_5448();
    }

    public boolean method_7652(class_1860<? super class_1263> recipe) {
        return recipe.method_8115((class_1263)this.craftingInventory, this.world);
    }

    public void method_7595(class_1657 playerEntity) {
        for (int i = 0; i < 9; ++i) {
            class_1542 itemEntity;
            class_1799 itemStack = this.craftingInventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            boolean insertInventorySuccess = playerEntity.method_31548().method_7394(itemStack);
            if (insertInventorySuccess && itemStack.method_7960()) {
                itemStack.method_7939(1);
                itemEntity = playerEntity.method_7328(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.method_6987();
                }
                playerEntity.field_6002.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((playerEntity.method_6051().method_43057() - playerEntity.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
                playerEntity.field_7512.method_7623();
                continue;
            }
            itemEntity = playerEntity.method_7328(itemStack, false);
            if (itemEntity == null) continue;
            itemEntity.method_6975();
            itemEntity.method_6984(playerEntity.method_5667());
        }
        super.method_7595(this.player);
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 transferStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 clickedSlotStack = slot.method_7677();
            transferStack = clickedSlotStack.method_7972();
            if (index == 14) {
                this.context.method_17393((world, pos) -> clickedSlotStack.method_7909().method_7843(clickedSlotStack, world, player));
                if (!this.method_7616(clickedSlotStack, 42, 51, false) && !this.method_7616(clickedSlotStack, 15, 42, false)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(clickedSlotStack, transferStack);
            } else if (index < 9) {
                if (!this.method_7616(clickedSlotStack, 42, 51, false) && !this.method_7616(clickedSlotStack, 15, 42, false)) {
                    return class_1799.field_8037;
                }
            } else {
                if (index < 14) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(clickedSlotStack, 0, 9, false)) {
                    return class_1799.field_8037;
                }
            }
            if (clickedSlotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (clickedSlotStack.method_7947() == transferStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, clickedSlotStack);
            if (index == 14) {
                player.method_7328(clickedSlotStack, false);
            }
        }
        return transferStack;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return super.method_7613(stack, slot);
    }

    public int method_7655() {
        return 14;
    }

    public int method_7653() {
        return 3;
    }

    public int method_7656() {
        return 3;
    }

    public int method_7658() {
        return 9;
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public boolean method_32339(int index) {
        return index != this.method_7655();
    }

    public Optional<PedestalRecipeTier> getTier() {
        return this.highestUnlockedRecipeTier;
    }
}

