/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.inventories.PaintbrushScreenHandler;
import de.dafuqs.spectrum.networking.SpectrumC2SPacketSender;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class PaintbrushScreen
extends class_465<PaintbrushScreenHandler> {
    public static final int TEXT_COLOR = 0xEEEEEE;
    public static final class_2960 BACKGROUND = new class_2960("spectrum", "textures/gui/paintbrush.png");
    protected static final class_2561 CONTROLS_TEXT_1 = class_2561.method_43471((String)"item.spectrum.paintbrush.gui.controls1");
    protected static final class_2561 CONTROLS_TEXT_2 = class_2561.method_43471((String)"item.spectrum.paintbrush.gui.controls2");
    public static final List<InkColor> MAIN_GRID = new ArrayList<InkColor>(){
        {
            this.add(InkColors.MAGENTA);
            this.add(InkColors.CYAN);
            this.add(InkColors.YELLOW);
            this.add(InkColors.BLACK);
        }
    };
    public static final List<InkColor> MAGENTA_GRID = new ArrayList<InkColor>(){
        {
            this.add(InkColors.RED);
            this.add(InkColors.PINK);
            this.add(null);
            this.add(InkColors.BROWN);
        }
    };
    public static final List<InkColor> CYAN_GRID = new ArrayList<InkColor>(){
        {
            this.add(InkColors.LIGHT_BLUE);
            this.add(InkColors.BLUE);
            this.add(InkColors.PURPLE);
            this.add(null);
        }
    };
    public static final List<InkColor> YELLOW_GRID = new ArrayList<InkColor>(){
        {
            this.add(null);
            this.add(InkColors.ORANGE);
            this.add(InkColors.LIME);
            this.add(InkColors.GREEN);
        }
    };
    public static final List<InkColor> BLACK_GRID = new ArrayList<InkColor>(){
        {
            this.add(InkColors.WHITE);
            this.add(null);
            this.add(InkColors.LIGHT_GRAY);
            this.add(InkColors.GRAY);
        }
    };
    public static final List<List<InkColor>> GRIDS = new ArrayList<List<InkColor>>(){
        {
            this.add(MAIN_GRID);
            this.add(MAGENTA_GRID);
            this.add(CYAN_GRID);
            this.add(YELLOW_GRID);
            this.add(BLACK_GRID);
        }
    };
    private static final List<class_3545<Integer, Integer>> SQUARE_OFFSETS = List.of(new class_3545((Object)-64, (Object)-16), new class_3545((Object)-16, (Object)-64), new class_3545((Object)32, (Object)-16), new class_3545((Object)-16, (Object)32));
    private int currentGrid = 0;

    public PaintbrushScreen(PaintbrushScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2779 = 256;
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        this.drawGrid(matrices, this.field_2792 / 2, this.field_2779 / 2, GRIDS.get(this.currentGrid));
        this.field_22793.method_30883(matrices, CONTROLS_TEXT_1, (float)((this.field_2792 - this.field_22793.method_27525((class_5348)CONTROLS_TEXT_1)) / 2), 202.0f, 0xEEEEEE);
        this.field_22793.method_30883(matrices, CONTROLS_TEXT_2, (float)((this.field_2792 - this.field_22793.method_27525((class_5348)CONTROLS_TEXT_2)) / 2), 212.0f, 0xEEEEEE);
    }

    protected void drawGrid(class_4587 matrices, int startX, int startY, List<InkColor> grid) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currentGrid == 0) {
            this.method_25302(matrices, startX - 5, startY - 5, 0, 0, 10, 10);
        } else {
            this.method_25302(matrices, startX - 14, startY - 14, 48, 0, 28, 28);
            RenderHelper.fillQuad(matrices, startX - 12, startY - 12, 24, 24, MAIN_GRID.get(this.currentGrid - 1).getColor());
        }
        Iterator<class_3545<Integer, Integer>> iOffset = SQUARE_OFFSETS.iterator();
        for (InkColor color : grid) {
            class_3545<Integer, Integer> offset = iOffset.next();
            if (color == null) continue;
            this.method_25302(matrices, startX + (Integer)offset.method_15442() - 3, startY + (Integer)offset.method_15441() - 3, 10, 0, 38, 38);
            RenderHelper.fillQuad(matrices, startX + (Integer)offset.method_15442(), startY + (Integer)offset.method_15441(), 32, 32, color.getColor());
        }
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.selectBack();
        } else {
            int centerElementSize;
            int startX = this.field_2792 / 2;
            int startY = this.field_2779 / 2;
            mouseX -= (double)this.field_2776;
            mouseY -= (double)this.field_2800;
            int n = centerElementSize = this.currentGrid == 0 ? 5 : 14;
            if (mouseX >= (double)(startX - centerElementSize) && mouseX <= (double)(startX + centerElementSize) && mouseY >= (double)(startY - centerElementSize) && mouseY <= (double)(startY + centerElementSize)) {
                this.selectCenter();
                return true;
            }
            List<InkColor> grid = GRIDS.get(this.currentGrid);
            Iterator<class_3545<Integer, Integer>> iOffset = SQUARE_OFFSETS.iterator();
            int offsetID = 0;
            for (InkColor color : grid) {
                class_3545<Integer, Integer> offset = iOffset.next();
                if (color != null && mouseX >= (double)(startX + (Integer)offset.method_15442()) && mouseX <= (double)(startX + (Integer)offset.method_15442() + 32) && mouseY >= (double)(startY + (Integer)offset.method_15441()) && mouseY <= (double)(startY + (Integer)offset.method_15441() + 32)) {
                    switch (offsetID) {
                        case 0: {
                            this.selectLeft();
                            return true;
                        }
                        case 1: {
                            this.selectUp();
                            return true;
                        }
                        case 2: {
                            this.selectRight();
                            return true;
                        }
                        case 3: {
                            this.selectDown();
                            return true;
                        }
                    }
                }
                ++offsetID;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_315 options = class_310.method_1551().field_1690;
        if (options.field_1913.method_1417(keyCode, scanCode)) {
            this.selectLeft();
            return true;
        }
        if (options.field_1894.method_1417(keyCode, scanCode)) {
            this.selectUp();
            return true;
        }
        if (options.field_1849.method_1417(keyCode, scanCode)) {
            this.selectRight();
            return true;
        }
        if (options.field_1881.method_1417(keyCode, scanCode)) {
            this.selectDown();
            return true;
        }
        if (options.field_1869.method_1417(keyCode, scanCode) || options.field_1822.method_1417(keyCode, scanCode)) {
            this.selectCenter();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void selectCenter() {
        if (this.currentGrid == 0) {
            this.chooseColor(null);
        } else {
            this.chooseColor(MAIN_GRID.get(this.currentGrid - 1));
        }
    }

    private void selectRight() {
        if (this.currentGrid == 0) {
            this.currentGrid = 3;
            this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f, false);
        } else {
            InkColor selectedColor = GRIDS.get(this.currentGrid).get(2);
            if (selectedColor == null) {
                this.selectBack();
            } else {
                this.chooseColor(selectedColor);
            }
        }
    }

    private void selectUp() {
        if (this.currentGrid == 0) {
            this.currentGrid = 2;
            this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f, false);
        } else {
            InkColor selectedColor = GRIDS.get(this.currentGrid).get(1);
            if (selectedColor == null) {
                this.selectBack();
            } else {
                this.chooseColor(selectedColor);
            }
        }
    }

    private void selectLeft() {
        if (this.currentGrid == 0) {
            this.currentGrid = 1;
            this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f, false);
        } else {
            InkColor selectedColor = GRIDS.get(this.currentGrid).get(0);
            if (selectedColor == null) {
                this.selectBack();
            } else {
                this.chooseColor(selectedColor);
            }
        }
    }

    private void selectDown() {
        if (this.currentGrid == 0) {
            if (((PaintbrushScreenHandler)this.field_2797).hasAccessToWhites()) {
                this.currentGrid = 4;
                this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f, false);
            } else {
                this.chooseColor(MAIN_GRID.get(3));
            }
        } else {
            InkColor selectedColor = GRIDS.get(this.currentGrid).get(3);
            if (selectedColor == null) {
                this.selectBack();
            } else {
                this.chooseColor(selectedColor);
            }
        }
    }

    private void selectBack() {
        if (this.currentGrid != 0) {
            this.currentGrid = 0;
            this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f, false);
        }
    }

    private void chooseColor(@Nullable InkColor inkColor) {
        SpectrumC2SPacketSender.sendInkColorSelectedInGUI(inkColor);
        this.field_22787.field_1687.method_2947(this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_PAINT, class_3419.field_15254, 0.6f, 1.0f, false);
        this.field_22787.field_1724.method_7346();
    }
}

