/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.blocks.energy.ColorPickerBlockEntity;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ColorSelectionWidget
extends class_339
implements class_4068,
class_364 {
    protected ColorPickerBlockEntity colorPicker;
    @Nullable
    private Consumer<InkColor> changedListener;
    protected class_437 screen;
    List<class_3545<InkColor, Boolean>> usableColors = new ArrayList<class_3545<InkColor, Boolean>>();
    int selectedDotX;
    int selectedDotY;

    public ColorSelectionWidget(int x, int y, int selectedDotX, int selectedDotY, class_437 screen, ColorPickerBlockEntity colorPicker) {
        super(x, y, 56, 14, (class_2561)class_2561.method_43470((String)""));
        this.colorPicker = colorPicker;
        this.selectedDotX = selectedDotX;
        this.selectedDotY = selectedDotY;
        this.screen = screen;
        for (InkColor inkColor : InkColor.all()) {
            this.usableColors.add((class_3545<InkColor, Boolean>)new class_3545((Object)inkColor, (Object)AdvancementHelper.hasAdvancementClient((class_2960)inkColor.getRequiredAdvancement())));
        }
    }

    public void setChangedListener(@Nullable Consumer<InkColor> changedListener) {
        this.changedListener = changedListener;
    }

    private void onChanged(InkColor newColor) {
        if (this.changedListener != null) {
            this.changedListener.accept(newColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean colorSelectionClicked;
        boolean colorUnselectionClicked;
        boolean bl = colorUnselectionClicked = mouseX >= (double)this.selectedDotX && mouseX < (double)(this.selectedDotX + 4) && mouseY >= (double)this.selectedDotY && mouseY < (double)(this.selectedDotY + 4);
        if (colorUnselectionClicked) {
            class_310.method_1551().field_1724.method_17356(SpectrumSoundEvents.BUTTON_CLICK, class_3419.field_15254, 1.0f, 1.0f);
            this.onChanged(null);
        }
        boolean bl2 = colorSelectionClicked = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        if (colorSelectionClicked && button == 0) {
            int xOffset = class_3532.method_15357((double)mouseX) - this.field_22760;
            int yOffset = class_3532.method_15357((double)mouseY) - this.field_22761;
            int horizontalColorOffset = xOffset / 7;
            int verticalColorOffset = yOffset / 7;
            int newColorIndex = horizontalColorOffset + verticalColorOffset * 8;
            InkColor newColor = InkColor.all().get(newColorIndex);
            if (this.colorPicker.getSelectedColor() != newColor) {
                if (AdvancementHelper.hasAdvancementClient((class_2960)newColor.getRequiredAdvancement())) {
                    class_310.method_1551().field_1724.method_17356(SpectrumSoundEvents.BUTTON_CLICK, class_3419.field_15254, 1.0f, 1.0f);
                    this.onChanged(newColor);
                } else {
                    class_310.method_1551().field_1724.method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 1.0f, 1.0f);
                    this.onChanged(null);
                }
            }
            return true;
        }
        return false;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"spectrum.narration.color_selection", (Object[])new Object[]{this.colorPicker.getSelectedColor()}));
    }

    public void draw(class_4587 matrices) {
        int i = -1;
        int currentX = this.field_22760 + 1;
        int currentY = this.field_22761 + 1;
        for (class_3545<InkColor, Boolean> color : this.usableColors) {
            if (((Boolean)color.method_15441()).booleanValue()) {
                RenderHelper.fillQuad(matrices, currentX, currentY, 5, 5, ((InkColor)color.method_15442()).getColor());
            }
            currentX += 7;
            if (++i != 7) continue;
            currentY += 7;
            currentX = this.field_22760 + 1;
        }
        InkColor selectedColor = this.colorPicker.getSelectedColor();
        if (selectedColor != null) {
            RenderHelper.fillQuad(matrices, this.selectedDotX, this.selectedDotY, 4, 4, selectedColor.getColor());
        }
    }

    public void drawMouseoverTooltip(class_4587 matrices, int mouseX, int mouseY) {
        boolean overUnselection;
        boolean bl = overUnselection = (double)mouseX >= (double)this.selectedDotX && (double)mouseX < (double)(this.selectedDotX + 4) && (double)mouseY >= (double)this.selectedDotY && (double)mouseY < (double)(this.selectedDotY + 4);
        if (overUnselection) {
            this.screen.method_32634(matrices, List.of(class_2561.method_43471((String)"spectrum.tooltip.ink_powered.unselect_color")), Optional.empty(), this.field_22760, this.field_22761);
        } else {
            int xOffset = class_3532.method_15375((float)mouseX) - this.field_22760;
            int yOffset = class_3532.method_15375((float)mouseY) - this.field_22761;
            int horizontalColorOffset = xOffset / 7;
            int verticalColorOffset = yOffset / 7;
            int newColorIndex = horizontalColorOffset + verticalColorOffset * 8;
            InkColor newColor = InkColor.all().get(newColorIndex);
            if (AdvancementHelper.hasAdvancementClient((class_2960)newColor.getRequiredAdvancement())) {
                this.screen.method_32634(matrices, List.of(newColor.getName()), Optional.empty(), this.field_22760, this.field_22761);
            } else {
                this.screen.method_32634(matrices, List.of(class_2561.method_43471((String)"spectrum.tooltip.ink_powered.unselect_color")), Optional.empty(), this.field_22760, this.field_22761);
            }
        }
    }
}

