/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.helpers.Support;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class InkGaugeWidget
extends class_332
implements class_4068,
class_364,
class_6379 {
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean hovered;
    protected class_437 screen;
    protected InkStorageBlockEntity blockEntity;

    public InkGaugeWidget(int x, int y, int width, int height, class_437 screen, InkStorageBlockEntity blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_4587 matrices, int x, int y) {
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
        int padding = 0;
        Map<InkColor, Long> energy = this.blockEntity.getEnergyStorage().getEnergy();
        for (Long l : energy.values()) {
            padding = Math.max(padding, StringUtils.length((CharSequence)String.valueOf(l)));
        }
        for (Map.Entry entry : energy.entrySet()) {
            long amount = (Long)entry.getValue();
            if (amount <= 0L) continue;
            tooltip.add(class_2561.method_43469((String)("spectrum.tooltip.ink_powered.bullet." + ((InkColor)entry.getKey()).toString().toLowerCase(Locale.ROOT)), (Object[])new Object[]{Support.getShortenedNumberString(amount)}));
        }
        if (tooltip.size() == 0) {
            tooltip.add(class_2561.method_43471((String)"spectrum.tooltip.ink_powered.empty"));
        } else {
            tooltip.add(0, class_2561.method_43471((String)"spectrum.tooltip.ink_powered.stored"));
        }
        this.screen.method_32634(matrices, tooltip, Optional.empty(), x, y);
    }

    public void draw(class_4587 matrices) {
        long totalInk = this.blockEntity.getEnergyStorage().getCurrentTotal();
        if (totalInk > 0L) {
            int centerX = this.x + this.width / 2;
            int centerY = this.y + this.width / 2;
            int radius = 22;
            double startRad = -1.5707963267948966;
            for (Map.Entry<InkColor, Long> entry : this.blockEntity.getEnergyStorage().getEnergy().entrySet()) {
                double curr;
                InkColor color = entry.getKey();
                long currentInk = entry.getValue();
                if (currentInk <= 0L) continue;
                for (double thisPart = (double)currentInk / (double)totalInk; thisPart > 0.0; thisPart -= curr) {
                    curr = Math.min(0.2, thisPart);
                    double endRad = startRad + curr * 2.0 * Math.PI;
                    int p2x = (int)((double)radius * Math.cos(startRad));
                    int p2y = (int)((double)radius * Math.sin(startRad));
                    int p3x = (int)((double)radius * Math.cos(endRad));
                    int p3y = (int)((double)radius * Math.sin(endRad));
                    RenderHelper.fillTriangle(matrices, centerX, centerY, centerX + p3x, centerY + p3y, centerX + p2x, centerY + p2y, color.getColor());
                    double middleRad = startRad + curr * Math.PI;
                    int pmx = (int)((double)radius * Math.cos(middleRad));
                    int pmy = (int)((double)radius * Math.sin(middleRad));
                    RenderHelper.fillTriangle(matrices, centerX + p3x, centerY + p3y, centerX + pmx, centerY + pmy, centerX + p2x, centerY + p2y, color.getColor());
                    startRad = endRad;
                }
            }
        }
    }
}

