/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.helpers.Support;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class StackedInkMeterWidget
extends class_332
implements class_4068,
class_364,
class_6379 {
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean hovered;
    protected class_437 screen;
    protected InkStorageBlockEntity blockEntity;

    public StackedInkMeterWidget(int x, int y, int width, int height, class_437 screen, InkStorageBlockEntity blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_4587 matrices, int x, int y) {
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        String readableCurrentTotalString = Support.getShortenedNumberString(currentTotal);
        String percent = Support.getSensiblePercent(inkStorage.getCurrentTotal(), inkStorage.getMaxTotal());
        this.screen.method_32634(matrices, List.of(class_2561.method_43469((String)"spectrum.tooltip.ink_powered.percent_filled", (Object[])new Object[]{readableCurrentTotalString, percent})), Optional.empty(), x, y);
    }

    public void draw(class_4587 matrices) {
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        if (currentTotal > 0L) {
            long maxTotal = inkStorage.getMaxTotal();
            int currentHeight = this.y + this.height;
            for (Map.Entry<InkColor, Long> entry : inkStorage.getEnergy().entrySet()) {
                long amount = entry.getValue();
                if (amount <= 0L) continue;
                int height = Math.round((float)amount / ((float)maxTotal / (float)this.height));
                if (height > 0) {
                    RenderHelper.fillQuad(matrices, this.x, currentHeight - height, height, this.width, entry.getKey().getColor());
                }
                currentHeight -= height;
            }
        }
    }
}

