/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.energy;

import de.dafuqs.spectrum.energy.InkStorageItem;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.items.LoomPatternProvider;
import de.dafuqs.spectrum.items.SpectrumBannerPatternItem;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class InkFlaskItem
extends class_1792
implements InkStorageItem<SingleInkStorage>,
LoomPatternProvider {
    private final long maxEnergy;

    public InkFlaskItem(class_1792.class_1793 settings, long maxEnergy) {
        super(settings);
        this.maxEnergy = maxEnergy;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.ALWAYS;
    }

    @Override
    public SingleInkStorage getEnergyStorage(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7969();
        if (compound != null && compound.method_10545("EnergyStore")) {
            return SingleInkStorage.fromNbt(compound.method_10562("EnergyStore"));
        }
        return new SingleInkStorage(this.maxEnergy);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Override
    public void setEnergyStorage(class_1799 itemStack, SingleInkStorage storage) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10566("EnergyStore", (class_2520)storage.toNbt());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.getEnergyStorage(stack).addTooltip(tooltip, true);
        SpectrumBannerPatternItem.addBannerPatternProviderTooltip(tooltip);
    }

    public class_1799 getFullStack(InkColor color) {
        class_1799 stack = this.method_7854();
        SingleInkStorage storage = this.getEnergyStorage(stack);
        storage.fillCompletely();
        storage.convertColor(color);
        this.setEnergyStorage(stack, storage);
        return stack;
    }

    @Override
    public class_6880<class_2582> getPattern() {
        return SpectrumBannerPatterns.INK_FLASK;
    }
}

