/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.entity.entity.InkProjectileEntity;
import de.dafuqs.spectrum.helpers.BlockVariantHelper;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.inventories.PaintbrushScreenHandler;
import de.dafuqs.spectrum.items.PigmentItem;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class PaintbrushItem
extends class_1792 {
    public static final class_2960 UNLOCK_COLORING_ADVANCEMENT_ID = SpectrumCommon.locate("collect_pigment");
    public static final class_2960 UNLOCK_INK_SLINGING_ADVANCEMENT_ID = SpectrumCommon.locate("midgame/fill_ink_container");
    public static final int COOLDOWN_DURATION_TICKS = 10;
    public static final int BLOCK_COLOR_COST = 25;
    public static final int INK_FLING_COST = 100;
    public static final String COLOR_NBT_STRING = "Color";
    private static final class_2561 GUI_TITLE = class_2561.method_43471((String)"item.spectrum.paintbrush");

    public PaintbrushItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        Optional<InkColor> color = PaintbrushItem.getColor(stack);
        boolean unlockedColoring = AdvancementHelper.hasAdvancementClient((class_2960)UNLOCK_COLORING_ADVANCEMENT_ID);
        boolean unlockedSlinging = AdvancementHelper.hasAdvancementClient((class_2960)UNLOCK_INK_SLINGING_ADVANCEMENT_ID);
        if (unlockedColoring || unlockedSlinging) {
            if (color.isPresent()) {
                tooltip.add((class_2561)class_2561.method_43471((String)("spectrum.ink.color." + color.get())));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.paintbrush.tooltip.select_color"));
            }
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.paintbrush.ability.header").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.paintbrush.ability.pedestal_triggering").method_27692(class_124.field_1080));
        if (unlockedColoring) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.paintbrush.ability.block_coloring").method_27692(class_124.field_1080));
        }
        if (unlockedSlinging) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.paintbrush.ability.ink_slinging").method_27692(class_124.field_1080));
        }
    }

    public static boolean canColor(class_1657 player) {
        return AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)UNLOCK_COLORING_ADVANCEMENT_ID);
    }

    public static boolean canInkSling(class_1657 player) {
        return AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)UNLOCK_INK_SLINGING_ADVANCEMENT_ID);
    }

    public class_3908 createScreenHandlerFactory(class_1937 world, class_3222 serverPlayerEntity, class_1799 itemStack) {
        return new class_747((syncId, inventory, player) -> new PaintbrushScreenHandler(syncId, inventory, class_3914.method_17392((class_1937)world, (class_2338)serverPlayerEntity.method_24515()), itemStack), GUI_TITLE);
    }

    public static void setColor(class_1799 stack, @Nullable InkColor color) {
        class_2487 compound = stack.method_7948();
        if (color == null) {
            compound.method_10551(COLOR_NBT_STRING);
        } else {
            compound.method_10582(COLOR_NBT_STRING, color.toString());
        }
        stack.method_7980(compound);
    }

    public static Optional<InkColor> getColor(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound != null && compound.method_10545(COLOR_NBT_STRING)) {
            return Optional.of(InkColor.of(compound.method_10558(COLOR_NBT_STRING)));
        }
        return Optional.empty();
    }

    public class_1269 method_7884(class_1838 context) {
        if (PaintbrushItem.canColor(context.method_8036()) && this.cursedColor(context)) {
            return class_1269.method_29236((boolean)context.method_8045().field_9236);
        }
        return super.method_7884(context);
    }

    private boolean cursedColor(class_1838 context) {
        if (context.method_8036() == null) {
            return false;
        }
        Optional<InkColor> optionalInkColor = PaintbrushItem.getColor(context.method_8041());
        if (optionalInkColor.isEmpty()) {
            return false;
        }
        InkColor inkColor = optionalInkColor.get();
        class_1767 dyeColor = inkColor.getDyeColor();
        if (this.payBlockColorCost(context.method_8036(), inkColor)) {
            class_2248 newBlock = BlockVariantHelper.getCursedBlockColorVariant(context.method_8045(), context.method_8037(), dyeColor);
            if (newBlock == class_2246.field_10124) {
                return false;
            }
            if (!context.method_8045().field_9236) {
                context.method_8045().method_8501(context.method_8037(), newBlock.method_9564());
                context.method_8045().method_8396(null, context.method_8037(), SpectrumSoundEvents.PAINTBRUSH_PAINT, class_3419.field_15245, 1.0f, 1.0f);
            }
            return true;
        }
        if (context.method_8045().field_9236) {
            context.method_8036().method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
        }
        return false;
    }

    private boolean payBlockColorCost(class_1657 player, InkColor inkColor) {
        return player.method_7337() || InkPowered.tryDrainEnergy(player, inkColor, 25L) || InventoryHelper.removeFromInventoryWithRemainders(player, PigmentItem.byColor(inkColor.getDyeColor()).method_7854());
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        Optional<InkColor> optionalInkColor;
        if (user.method_5715()) {
            class_3222 serverPlayerEntity;
            if (user instanceof class_3222 && PaintbrushItem.canColor((class_1657)(serverPlayerEntity = (class_3222)user))) {
                serverPlayerEntity.method_17355(this.createScreenHandlerFactory(world, serverPlayerEntity, user.method_5998(hand)));
            }
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        if (PaintbrushItem.canInkSling(user) && (optionalInkColor = PaintbrushItem.getColor(user.method_5998(hand))).isPresent()) {
            InkColor inkColor = optionalInkColor.get();
            if (user.method_7337() || InkPowered.tryDrainEnergy(user, inkColor, 100L)) {
                user.method_7357().method_7906((class_1792)this, 10);
                if (!world.field_9236) {
                    InkProjectileEntity paintProjectile = new InkProjectileEntity(world, (class_1309)user);
                    paintProjectile.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 2.0f, 1.0f);
                    paintProjectile.setColor(inkColor);
                    world.method_8649((class_1297)paintProjectile);
                }
                if (!user.method_7337()) {
                    this.causeKnockback(user, user.method_36454(), user.method_36455(), 0.0f, 0.3f);
                }
            } else if (world.field_9236) {
                user.method_17356(SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    private void causeKnockback(class_1657 user, float yaw, float pitch, float roll, float multiplier) {
        float f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180))) * multiplier;
        float g = class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180))) * multiplier;
        float h = -class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180))) * multiplier;
        user.method_5762((double)f, (double)g, (double)h);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        boolean colored;
        Optional<InkColor> color;
        if (PaintbrushItem.canColor(user) && (color = PaintbrushItem.getColor(stack)).isPresent() && this.payBlockColorCost(user, color.get()) && (colored = ColorHelper.tryColorEntity(user, (class_1297)entity, color.get().getDyeColor()))) {
            return class_1269.method_29236((boolean)user.field_6002.field_9236);
        }
        return super.method_7847(stack, user, entity, hand);
    }
}

