/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import oshi.util.tuples.Triplet;

public class PlacementStaffItem
extends BuildingStaffItem
implements InkPowered {
    public static final InkColor USED_COLOR = InkColors.CYAN;
    public static final int INK_COST_PER_BLOCK = 1;
    public static final int CREATIVE_RANGE = 10;

    public PlacementStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static int getRange(class_1657 playerEntity) {
        if (playerEntity == null || playerEntity.method_7337()) {
            return 10;
        }
        Optional<PedestalRecipeTier> highestUnlockedRecipeTier = PedestalRecipeTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 10;
                }
                case ADVANCED: {
                    return 7;
                }
            }
            return 4;
        }
        return 3;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.addInkPoweredTooltip(tooltip);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.constructors_staff.tooltip.range", (Object[])new Object[]{PlacementStaffItem.getRange((class_1657)class_310.method_1551().field_1724)}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.constructors_staff.tooltip.crouch").method_27692(class_124.field_1080));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 targetBlockState = world.method_8320(pos);
        if (player != null && player.method_7337() || !PlacementStaffItem.isBlacklisted(targetBlockState)) {
            class_2248 targetBlock = targetBlockState.method_26204();
            class_1792 targetBlockItem = targetBlock.method_8389();
            if (player != null && targetBlockItem != class_1802.field_8162) {
                int count;
                if (player.method_7337()) {
                    count = Integer.MAX_VALUE;
                } else {
                    Triplet<class_2248, class_1792, Integer> inventoryItemAndCount = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars(player, targetBlock);
                    if (targetBlock != inventoryItemAndCount.getA()) {
                        targetBlockState = ((class_2248)inventoryItemAndCount.getA()).method_9564();
                    }
                    targetBlockItem = (class_1792)inventoryItemAndCount.getB();
                    count = (Integer)inventoryItemAndCount.getC();
                    count = InkPowered.canUse(player) ? Math.min(count, 1 + (int)InkPowered.getAvailableInk(player, USED_COLOR) / 1) : 0;
                }
                if (count > 0) {
                    boolean sneaking;
                    int range;
                    class_2350 side = context.method_8038();
                    List<class_2338> targetPositions = BuildingHelper.calculateBuildingStaffSelection(world, pos, side, count, range = Math.min(PlacementStaffItem.getRange(player), player.method_7337() ? PlacementStaffItem.getRange(player) : count), !(sneaking = player.method_5715()));
                    if (targetPositions.isEmpty()) {
                        return class_1269.field_5814;
                    }
                    int taken = 0;
                    if (!world.field_9236) {
                        for (class_2338 position : targetPositions) {
                            class_2680 originalState = world.method_8320(position);
                            if (!originalState.method_26215() && originalState.method_26227().method_15769() && (!originalState.method_26207().method_15800() || !originalState.method_26220((class_1922)world, position).method_1110())) continue;
                            world.method_8501(position, targetBlockState);
                            ++taken;
                        }
                        if (!player.method_7337()) {
                            class_1792 finalTargetBlockItem = targetBlockItem;
                            player.method_31548().method_29280(stack -> stack.method_7909().equals(finalTargetBlockItem), taken, (class_1263)player.method_31548());
                            InkPowered.tryDrainEnergy(player, USED_COLOR, (long)targetPositions.size() * 1L);
                        }
                        if (taken > 0) {
                            world.method_8396(null, player.method_24515(), targetBlockState.method_26231().method_10598(), class_3419.field_15248, targetBlockState.method_26231().method_10597(), targetBlockState.method_26231().method_10599());
                        }
                    }
                    return class_1269.field_5812;
                }
            }
        } else if (player != null) {
            world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_1269.field_5814;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }
}

