/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5328;

public class RadianceStaffItem
extends class_1792
implements InkPowered {
    public static final int COOLDOWN_DURATION_TICKS = 10;
    public static final int USE_DURATION = 12;
    public static final int REACH_STEP_DISTANCE = 4;
    public static final int MAX_REACH_STEPS = 8;
    public static final int MIN_LIGHT_LEVEL = 10;
    public static final class_1799 COST = new class_1799((class_1935)SpectrumItems.SHIMMERSTONE_GEM, 1);

    public RadianceStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean placeLight(class_1937 world, class_2338 targetPos, class_3222 playerEntity) {
        class_2680 targetBlockState = world.method_8320(targetPos);
        if (targetBlockState.method_26215()) {
            if (playerEntity.method_7337() || InkPowered.tryDrainEnergy((class_1657)playerEntity, (InkColor)InkColors.YELLOW, 10L) || InventoryHelper.removeFromInventoryWithRemainders((class_1657)playerEntity, COST)) {
                world.method_8652(targetPos, SpectrumBlocks.WAND_LIGHT_BLOCK.method_9564(), 3);
                return true;
            }
        } else if (targetBlockState.method_27852(class_2246.field_10382) && (playerEntity.method_7337() || InkPowered.tryDrainEnergy((class_1657)playerEntity, (InkColor)InkColors.YELLOW, 10L) || InventoryHelper.removeFromInventoryWithRemainders((class_1657)playerEntity, COST))) {
            world.method_8652(targetPos, (class_2680)SpectrumBlocks.WAND_LIGHT_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public static void playSoundAndParticles(class_1937 world, class_2338 targetPos, class_3222 playerEntity, int useTimes, int iteration) {
        float pitch = useTimes % 2 == 0 ? Math.min(1.35f, 0.7f + 0.1f * (float)useTimes) : Math.min(1.5f, 0.7f + 0.1f * (float)useTimes);
        SpectrumS2CPacketSender.sendLightCreatedParticle(world, targetPos);
        world.method_43128(null, playerEntity.method_23317() + 0.5, playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, SpectrumSoundEvents.RADIANCE_STAFF_PLACE, class_3419.field_15248, (float)Math.max(0.25, (double)(1.0f - (float)iteration * 0.1f)), pitch);
    }

    public static void playDenySound(class_1937 world, class_1657 playerEntity) {
        world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 0.8f + playerEntity.method_6051().method_43057() * 0.4f);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (InkPowered.canUseClient()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip.ink"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip"));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip2"));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.RADIANCE_STAFF_CHARGING, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)user;
            if (user.method_6048() > 12 && user.method_6048() % 12 == 0) {
                this.usage(world, stack, serverPlayerEntity);
            }
        }
    }

    public void usage(class_1937 world, class_1799 stack, class_3222 user) {
        int useTimes = user.method_6048() / 12;
        int maxCheckDistance = Math.min(8, useTimes);
        class_2338 sourcePos = user.method_24515();
        class_243 cameraVec = user.method_5828(0.0f);
        for (int iteration = 1; iteration < maxCheckDistance; ++iteration) {
            class_2338 targetPos = sourcePos.method_10080(cameraVec.field_1352 * (double)iteration * 4.0, cameraVec.field_1351 * (double)iteration * 4.0, cameraVec.field_1350 * (double)iteration * 4.0);
            if (world.method_8314(class_1944.field_9282, targetPos = targetPos.method_10069(iteration - world.method_8409().method_43048(2 * iteration), iteration - world.method_8409().method_43048(2 * iteration), iteration - world.method_8409().method_43048(2 * iteration))) >= 10) continue;
            if (this.placeLight(world, targetPos, user)) {
                RadianceStaffItem.playSoundAndParticles(world, targetPos, user, useTimes, iteration);
                break;
            }
            RadianceStaffItem.playDenySound(world, (class_1657)user);
            break;
        }
    }

    public int method_7837() {
        return 8;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(InkColors.YELLOW);
    }
}

