/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.items.ActivatableItem;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class DreamflayerItem
extends class_1829
implements FabricItem,
InkPowered,
ActivatableItem {
    public static final InkColor USED_COLOR = InkColors.RED;
    public static final long INK_COST_FOR_ACTIVATION = 200L;
    public static final long INK_COST_PER_SECOND = 20L;
    public static float ARMOR_DIFFERENCE_DAMAGE_MULTIPLIER = 2.5f;
    public final float attackDamage;
    public final float attackSpeed;

    public DreamflayerItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
    }

    public static float getDamageAfterModifier(float amount, class_1309 attacker, class_1309 target) {
        float damageMultiplier = ((float)target.method_6096() + ARMOR_DIFFERENCE_DAMAGE_MULTIPLIER) / ((float)attacker.method_6096() + ARMOR_DIFFERENCE_DAMAGE_MULTIPLIER);
        return amount * damageMultiplier;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (hand == class_1268.field_5808 && user.method_5715()) {
            boolean isActivated = ActivatableItem.isActivated(stack);
            if (isActivated) {
                ActivatableItem.setActivated(stack, false);
                if (!world.field_9236) {
                    world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else if (InkPowered.tryDrainEnergy(user, USED_COLOR, 200L)) {
                ActivatableItem.setActivated(stack, true);
                if (!world.field_9236) {
                    world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_ACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else if (!world.field_9236) {
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1271.method_22430((Object)stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_3222 player;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.field_9236) {
            if (ActivatableItem.isActivated(stack)) {
                class_243 pos = entity.method_19538();
                world.method_8406((class_2394)SpectrumParticleTypes.RED_CRAFTING, pos.method_10216() + world.field_9229.method_43058(), pos.method_10214() + 1.05, pos.method_10215() + world.field_9229.method_43058(), 0.0, 0.1, 0.0);
            }
        } else if (world.method_8510() % 20L == 0L && ActivatableItem.isActivated(stack) && entity instanceof class_3222 && !InkPowered.tryDrainEnergy((class_1657)(player = (class_3222)entity), USED_COLOR, 20L)) {
            ActivatableItem.setActivated(stack, false);
            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.DREAMFLAYER_DEACTIVATE, class_3419.field_15248, 0.8f, 1.0f);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip2").method_27692(class_124.field_1080));
        if (ActivatableItem.isActivated(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip.activated").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.dreamflayer.tooltip.deactivated").method_27692(class_124.field_1080));
        }
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(class_1799 before, class_1799 after) {
        return !after.method_31574((class_1792)this) || ActivatableItem.isActivated(before) != ActivatableItem.isActivated(after);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == class_1304.field_6173) {
            if (ActivatableItem.isActivated(stack)) {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage * 1.5, class_1322.class_1323.field_6328));
                builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed * 0.75, class_1322.class_1323.field_6328));
            } else {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
                builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
            }
        }
        return builder.build();
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addInkPoweredTooltip(List<class_2561> tooltip) {
        InkPowered.super.addInkPoweredTooltip(tooltip);
    }
}

