/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class AttackRingItem
extends SpectrumTrinketItem {
    public static final UUID ATTACK_RING_DAMAGE_UUID = UUID.fromString("15d1fb68-6440-404a-aa31-7bf3310d3f52");

    public AttackRingItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("progression/unlock_jeopardant"));
    }

    public static double getAttackModifierForEntity(class_1309 entity) {
        if (entity == null) {
            return 0.0;
        }
        double mod = entity.method_6063() / (entity.method_6032() * entity.method_6032() + 1.0f);
        return Math.max(0.0, 1.0 + Math.log10(mod));
    }

    @Override
    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onUnequip(stack, slot, entity);
        if (entity.method_6127().method_27305(class_5134.field_23721, ATTACK_RING_DAMAGE_UUID)) {
            Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
            class_1322 modifier = new class_1322(ATTACK_RING_DAMAGE_UUID, "spectrum:jeopardant", AttackRingItem.getAttackModifierForEntity(entity), class_1322.class_1323.field_6331);
            map.put((Object)class_5134.field_23721, (Object)modifier);
            entity.method_6127().method_26847(map);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        long mod = Math.round(AttackRingItem.getAttackModifierForEntity((class_1309)class_310.method_1551().field_1724) * 100.0);
        if (mod == 0L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.jeopardant.tooltip.damage_zero"));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.jeopardant.tooltip.damage", (Object[])new Object[]{mod}));
        }
    }
}

