/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.energy.InkStorageItem;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.FixedSingleInkStorage;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class InkDrainTrinketItem
extends SpectrumTrinketItem
implements InkStorageItem<FixedSingleInkStorage> {
    public static final int MAX_INK = 0x320000;
    public final InkColor inkColor;

    public InkDrainTrinketItem(class_1792.class_1793 settings, class_2960 unlockIdentifier, InkColor inkColor) {
        super(settings, unlockIdentifier);
        this.inkColor = inkColor;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        if (storedInk >= 0x320000L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_drain.tooltip.maxed_out").method_27692(class_124.field_1080));
        } else {
            long nextStepInk;
            int pow = 0;
            do {
                nextStepInk = (long)(100.0 * Math.pow(8.0, pow));
                ++pow;
            } while (storedInk >= nextStepInk);
            tooltip.add((class_2561)class_2561.method_43469((String)("spectrum.tooltip.ink_drain.tooltip.ink_for_next_step." + inkStorage.getStoredColor().toString()), (Object[])new Object[]{Support.getShortenedNumberString(nextStepInk - storedInk)}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return this.isMaxedOut(stack);
    }

    private boolean isMaxedOut(class_1799 stack) {
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        return storedInk >= 0x320000L;
    }

    public class_1814 method_7862(class_1799 stack) {
        return this.isMaxedOut(stack) ? class_1814.field_8904 : super.method_7862(stack);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.NEVER;
    }

    @Override
    public FixedSingleInkStorage getEnergyStorage(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7969();
        if (compound != null && compound.method_10545("EnergyStore")) {
            return FixedSingleInkStorage.fromNbt(compound.method_10562("EnergyStore"));
        }
        return new FixedSingleInkStorage(0x320000L, this.inkColor);
    }

    @Override
    public void setEnergyStorage(class_1799 itemStack, FixedSingleInkStorage storage) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10566("EnergyStore", (class_2520)storage.toNbt());
    }

    @Override
    public class_1799 getFullStack() {
        return InkStorageItem.super.getFullStack();
    }
}

