/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.dafuqs.spectrum.interfaces.PotionFillable;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PotionPendantItem
extends SpectrumTrinketItem
implements PotionFillable {
    private static final int TRIGGER_EVERY_X_TICKS = 300;
    private static final int EFFECT_DURATION = 520;
    int maxEffectCount;
    int maxAmplifier;

    public PotionPendantItem(class_1792.class_1793 settings, int maxEffectCount, int maxAmplifier, class_2960 unlockIdentifier) {
        super(settings, unlockIdentifier);
        this.maxEffectCount = maxEffectCount;
        this.maxAmplifier = maxAmplifier;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        List effects = class_1844.method_8068((class_1799)stack);
        if (effects.size() > 0) {
            class_5250 mutableText;
            ArrayList attributeModifiers = Lists.newArrayList();
            for (class_1293 effect : effects) {
                mutableText = class_2561.method_43471((String)effect.method_5586());
                if (effect.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
                }
                tooltip.add((class_2561)mutableText.method_27692(effect.method_5579().method_18792().method_18793()));
                Map map = effect.method_5579().method_5565();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entityAttributeEntityAttributeModifierEntry;
                    Map.Entry entry = entityAttributeEntityAttributeModifierEntry = iterator.next();
                    class_1322 entityAttributeModifier = (class_1322)entry.getValue();
                    class_1322 entityAttributeModifier2 = new class_1322(entityAttributeModifier.method_6185(), effect.method_5579().method_5563(effect.method_5578(), entityAttributeModifier), entityAttributeModifier.method_6182());
                    attributeModifiers.add(new Pair(entry.getKey(), (Object)entityAttributeModifier2));
                }
            }
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
                for (Pair entityAttributeEntityAttributeModifierPair : attributeModifiers) {
                    mutableText = (class_1322)entityAttributeEntityAttributeModifierPair.getSecond();
                    double statusEffect = mutableText.method_6186();
                    double d = mutableText.method_6182() != class_1322.class_1323.field_6330 && mutableText.method_6182() != class_1322.class_1323.field_6331 ? mutableText.method_6186() : mutableText.method_6186() * 100.0;
                    if (statusEffect > 0.0) {
                        tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + mutableText.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d), class_2561.method_43471((String)((class_1320)entityAttributeEntityAttributeModifierPair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                        continue;
                    }
                    if (!(statusEffect < 0.0)) continue;
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + mutableText.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d *= -1.0), class_2561.method_43471((String)((class_1320)entityAttributeEntityAttributeModifierPair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
                }
            }
        }
        int maxEffectCount = this.maxEffectCount();
        if (effects.size() < maxEffectCount) {
            if (maxEffectCount == 1) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion_pendant.tooltip_not_full_one"));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.potion_pendant.tooltip_not_full_count", (Object[])new Object[]{maxEffectCount}));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion_pendant.tooltip_max_level").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (this.maxAmplifier + 1)))));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || class_1844.method_8068((class_1799)stack).size() > 0;
    }

    @Override
    public int maxEffectCount() {
        return this.maxEffectCount;
    }

    @Override
    public int maxEffectAmplifier() {
        return this.maxAmplifier;
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        if (!entity.method_37908().field_9236 && entity.method_37908().method_8510() % 300L == 0L) {
            this.giveEffects(stack, entity);
        }
    }

    private void giveEffects(class_1799 stack, class_1309 entity) {
        List effects = class_1844.method_8068((class_1799)stack);
        for (class_1293 effect : effects) {
            entity.method_6092(new class_1293(effect.method_5579(), 520, effect.method_5578(), effect.method_5591(), effect.method_5581(), true));
        }
    }
}

