/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_4081;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhispyCircletItem
extends SpectrumTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 100;
    private static final int NEGATIVE_EFFECT_SHORTENING_TICKS = 200;

    public WhispyCircletItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("progression/unlock_whispy_circlet"));
    }

    public static void removeSingleHarmfulStatusEffect(@NotNull class_1309 entity) {
        Collection currentEffects = entity.method_6026();
        if (currentEffects.size() == 0) {
            return;
        }
        ArrayList<class_1293> negativeEffects = new ArrayList<class_1293>();
        for (class_1293 statusEffectInstance : currentEffects) {
            class_1291 effect = statusEffectInstance.method_5579();
            if (effect.method_18792() != class_4081.field_18272 || SpectrumStatusEffectTags.isUncurable(effect)) continue;
            negativeEffects.add(statusEffectInstance);
        }
        if (negativeEffects.size() == 0) {
            return;
        }
        int randomIndex = entity.field_6002.field_9229.method_43048(negativeEffects.size());
        entity.method_6016(((class_1293)negativeEffects.get(randomIndex)).method_5579());
    }

    public static void removeNegativeStatusEffects(@NotNull class_1309 entity) {
        HashSet<class_1291> effectsToRemove = new HashSet<class_1291>();
        Collection currentEffects = entity.method_6026();
        for (class_1293 instance : currentEffects) {
            if (!WhispyCircletItem.affects(instance.method_5579())) continue;
            effectsToRemove.add(instance.method_5579());
        }
        for (class_1291 effect : effectsToRemove) {
            entity.method_6016(effect);
        }
    }

    public static void shortenNegativeStatusEffects(@NotNull class_1309 entity, int duration) {
        ArrayList<class_1293> newEffects = new ArrayList<class_1293>();
        ArrayList<class_1291> effectTypesToClear = new ArrayList<class_1291>();
        for (class_1293 instance : entity.method_6026()) {
            if (!WhispyCircletItem.affects(instance.method_5579())) continue;
            int newDurationTicks = instance.method_5584() - duration;
            if (newDurationTicks > 0) {
                newEffects.add(new class_1293(instance.method_5579(), newDurationTicks, instance.method_5578(), instance.method_5591(), instance.method_5581(), true));
            }
            if (effectTypesToClear.contains(instance.method_5579())) continue;
            effectTypesToClear.add(instance.method_5579());
        }
        for (class_1291 effectTypeToClear : effectTypesToClear) {
            entity.method_6016(effectTypeToClear);
        }
        for (class_1293 newEffect : newEffects) {
            entity.method_6092(newEffect);
        }
    }

    public static boolean affects(class_1291 statusEffect) {
        return statusEffect.method_18792() == class_4081.field_18272 && !SpectrumStatusEffectTags.isUncurable(statusEffect);
    }

    public static void preventPhantomSpawns(@NotNull class_3222 serverPlayerEntity) {
        serverPlayerEntity.method_14248().method_15023((class_1657)serverPlayerEntity, class_3468.field_15419.method_14956((Object)class_3468.field_15429), 0);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.whispy_circlet.tooltip3").method_27692(class_124.field_1080));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        if (!entity.field_6002.field_9236) {
            long time = entity.method_37908().method_8510();
            if (time % 100L == 0L) {
                WhispyCircletItem.shortenNegativeStatusEffects(entity, 200);
            }
            if (time % 10000L == 0L && entity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)entity;
                WhispyCircletItem.preventPhantomSpawns(serverPlayerEntity);
            }
        }
    }
}

