/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.dafuqs.spectrum.loot.SpectrumLootConditionTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_169;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class RandomChanceWithTreasureHunterLootCondition
implements class_5341 {
    private final float chance;
    private final class_1799 advancementTriggerItemStack;

    private RandomChanceWithTreasureHunterLootCondition(float chance, class_1792 item) {
        this.chance = chance;
        this.advancementTriggerItemStack = new class_1799((class_1935)item);
    }

    public static class_5341.class_210 builder(float chance, class_1792 advancementTriggerItem) {
        return () -> new RandomChanceWithTreasureHunterLootCondition(chance, advancementTriggerItem);
    }

    public class_5342 method_29325() {
        return SpectrumLootConditionTypes.RANDOM_CHANCE_WITH_TREASURE_HUNTER;
    }

    public Set<class_169<?>> method_293() {
        return ImmutableSet.of((Object)class_181.field_1230);
    }

    public boolean test(class_47 lootContext) {
        class_1297 killerEntity;
        boolean success;
        class_1297 entity = (class_1297)lootContext.method_296(class_181.field_1230);
        int treasureHunterLevel = 0;
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            if (!SpectrumEnchantments.TREASURE_HUNTER.canEntityUse((class_1297)playerEntity)) {
                return false;
            }
            treasureHunterLevel = class_1890.method_8203((class_1887)SpectrumEnchantments.TREASURE_HUNTER, (class_1309)((class_1309)entity));
        }
        if (treasureHunterLevel == 0) {
            return false;
        }
        boolean bl = success = lootContext.method_294().method_43057() < this.chance * (float)treasureHunterLevel;
        if (success && (killerEntity = (class_1297)lootContext.method_296(class_181.field_1230)) instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)killerEntity;
            SpectrumAdvancementCriteria.TREASURE_HUNTER_DROP.trigger(serverPlayerEntity, this.advancementTriggerItemStack);
        }
        return success;
    }

    public static class Serializer
    implements class_5335<RandomChanceWithTreasureHunterLootCondition> {
        public void toJson(JsonObject jsonObject, RandomChanceWithTreasureHunterLootCondition randomChanceWithLootingLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("chance", (Number)Float.valueOf(randomChanceWithLootingLootCondition.chance));
            jsonObject.addProperty("advancement_trigger_itemstack", class_2378.field_11142.method_10221((Object)randomChanceWithLootingLootCondition.advancementTriggerItemStack.method_7909()).toString());
        }

        public RandomChanceWithTreasureHunterLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new RandomChanceWithTreasureHunterLootCondition(class_3518.method_15259((JsonObject)jsonObject, (String)"chance"), (class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"advancement_trigger_itemstack"))));
        }
    }
}

