/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.enchantments.DisarmingEnchantment;
import de.dafuqs.spectrum.interfaces.ArmorWithHitEffect;
import de.dafuqs.spectrum.items.ActivatableItem;
import de.dafuqs.spectrum.items.ApplyFoodEffectsCallback;
import de.dafuqs.spectrum.items.tools.DreamflayerItem;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.StackableStatusEffect;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected class_1657 field_6258;
    @Shadow
    @Final
    private class_2371<class_1799> field_6248;

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract boolean method_6061(class_1282 var1);

    @Shadow
    protected abstract void method_6074(class_1282 var1, float var2);

    @Shadow
    public abstract class_1799 method_6047();

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    public abstract boolean method_6049(class_1293 var1);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @ModifyArg(method={"dropXp()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    protected int spectrum$applyExuberance(int originalXP) {
        return (int)((float)originalXP * this.spectrum$getExuberanceMod(this.field_6258));
    }

    private float spectrum$getExuberanceMod(class_1657 attackingPlayer) {
        if (attackingPlayer != null && SpectrumEnchantments.EXUBERANCE.canEntityUse((class_1297)attackingPlayer)) {
            int exuberanceLevel = class_1890.method_8203((class_1887)SpectrumEnchantments.EXUBERANCE, (class_1309)attackingPlayer);
            return 1.0f + (float)exuberanceLevel * SpectrumCommon.CONFIG.ExuberanceBonusExperiencePercentPerLevel;
        }
        return 1.0f;
    }

    @Inject(at={@At(value="HEAD")}, method={"fall(DZLnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)V"})
    public void spectrum$mitigateFallDamageWithPuffCirclet(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition, CallbackInfo ci) {
        int charges;
        Optional component;
        class_1309 thisEntity;
        if (onGround && thisEntity.field_6017 > (float)(thisEntity = (class_1309)this).method_5850() && (component = TrinketsApi.getTrinketComponent((class_1309)thisEntity)).isPresent() && !((TrinketComponent)component.get()).getEquipped(SpectrumItems.PUFF_CIRCLET).isEmpty() && (charges = AzureDikeProvider.getAzureDikeCharges(thisEntity)) > 0) {
            AzureDikeProvider.absorbDamage(thisEntity, 2.0f);
            thisEntity.field_6017 = 0.0f;
            thisEntity.method_18800(thisEntity.method_18798().field_1352, 0.5, thisEntity.method_18798().field_1350);
            thisEntity.method_37908().method_8396(null, thisEntity.method_24515(), SpectrumSoundEvents.PUFF_CIRCLET_PFFT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, argsOnly=true)
    public float spectrum$applyAzureDikeDamageProtection(float amount, class_1282 source) {
        @Nullable class_1293 vulnerability = this.method_6112(SpectrumStatusEffects.VULNERABILITY);
        if (vulnerability != null) {
            amount *= 1.0f + 0.25f * (float)vulnerability.method_5578();
        }
        if (source.method_5538() || source.method_5504() || this.method_6061(source) || amount <= 0.0f || ((class_1297)this).method_5679(source) || source.method_5534() && this.method_6059(class_1294.field_5918)) {
            return amount;
        }
        return AzureDikeProvider.absorbDamage((class_1309)this, amount);
    }

    @Inject(at={@At(value="RETURN")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    public void spectrum$applyDisarmingEnchantment(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        int disarmingLevel;
        class_1309 livingSource;
        class_1297 class_12972;
        if (cir.getReturnValue() != null && ((Boolean)cir.getReturnValue()).booleanValue() && (class_12972 = source.method_5529()) instanceof class_1309 && SpectrumEnchantments.DISARMING.canEntityUse((class_1297)(livingSource = (class_1309)class_12972)) && (disarmingLevel = class_1890.method_8225((class_1887)SpectrumEnchantments.DISARMING, (class_1799)livingSource.method_6047())) > 0 && Math.random() < (double)((float)disarmingLevel * SpectrumCommon.CONFIG.DisarmingChancePerLevelMobs)) {
            DisarmingEnchantment.disarmEntity((class_1309)this, this.field_6248);
        }
    }

    @ModifyVariable(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    public float spectrum$applyDreamflayerDamage(float amount, class_1282 source) {
        class_1297 class_12972;
        class_1297 class_12973 = source.method_5529();
        if (!(class_12973 instanceof class_1309)) {
            return amount;
        }
        class_1309 attacker = (class_1309)class_12973;
        class_1309 target = (class_1309)this;
        if (amount > 0.0f && source instanceof class_1285 && (class_12972 = source.method_5526()) instanceof class_1309) {
            class_1309 livingSource = (class_1309)class_12972;
            class_1799 mainHandStack = attacker.method_6047();
            if (mainHandStack.method_31574((class_1792)SpectrumItems.DREAMFLAYER)) {
                if (ActivatableItem.isActivated(mainHandStack)) {
                    float newDamage = DreamflayerItem.getDamageAfterModifier(amount, attacker, target);
                    if (!source.method_5527() && newDamage >= 1.0f) {
                        this.method_6074(class_1282.method_5536((class_1297)livingSource, (class_1297)livingSource), amount / 2.0f);
                    }
                    float quarterDamage = newDamage / 4.0f;
                    float h = target.method_6032();
                    target.method_6033(h - quarterDamage);
                    target.method_6066().method_5547(source, h, quarterDamage);
                    if (target.method_29504()) {
                        target.method_6078(source);
                    }
                    return quarterDamage;
                }
                float newDamage = DreamflayerItem.getDamageAfterModifier(amount, attacker, target);
                if (!source.method_5527() && newDamage >= 1.0f) {
                    this.method_6074(class_1282.method_5536((class_1297)livingSource, (class_1297)livingSource), amount / 4.0f);
                }
                return newDamage / 4.0f * 3.0f;
            }
        }
        return amount;
    }

    @Inject(at={@At(value="RETURN")}, method={"tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z"}, cancellable=true)
    public void spectrum$checkForTotemPendant(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 thisEntity;
        Optional optionalTrinketComponent;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && (optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)(thisEntity = (class_1309)this))).isPresent()) {
            List totems = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(SpectrumItems.TOTEM_PENDANT);
            for (class_3545 pair : totems) {
                if (((class_1799)pair.method_15441()).method_7947() <= 0) continue;
                ((class_1799)pair.method_15441()).method_7934(1);
                thisEntity.method_6033(1.0f);
                thisEntity.method_6012();
                thisEntity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
                thisEntity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
                thisEntity.method_6092(new class_1293(class_1294.field_5918, 800, 0));
                thisEntity.field_6002.method_8421((class_1297)thisEntity, (byte)35);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isDead()Z", ordinal=1)})
    public void spectrum$TriggerArmorWithHitEffect(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        block2: {
            Object object;
            block3: {
                if (((class_1309)this).field_6002.field_9236) break block2;
                object = this;
                if (!(object instanceof class_1308)) break block3;
                class_1308 thisMobEntity = (class_1308)object;
                for (class_1799 armorItemStack : thisMobEntity.method_5661()) {
                    if (!(armorItemStack.method_7909() instanceof ArmorWithHitEffect)) continue;
                    ((ArmorWithHitEffect)armorItemStack.method_7909()).onHit(armorItemStack, source, (class_1309)thisMobEntity, amount);
                }
                break block2;
            }
            object = this;
            if (!(object instanceof class_3222)) break block2;
            class_3222 thisPlayerEntity = (class_3222)object;
            for (class_1799 armorItemStack : thisPlayerEntity.method_5661()) {
                if (!(armorItemStack.method_7909() instanceof ArmorWithHitEffect)) continue;
                ((ArmorWithHitEffect)armorItemStack.method_7909()).onHit(armorItemStack, source, (class_1309)thisPlayerEntity, amount);
            }
        }
    }

    @Inject(method={"canHaveStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void spectrum$canHaveStatusEffect(class_1293 statusEffectInstance, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && this.method_6059(SpectrumStatusEffects.IMMUNITY) && statusEffectInstance.method_5579().method_18792() == class_4081.field_18272 && !SpectrumStatusEffectTags.isUncurable(statusEffectInstance.method_5579())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setSprinting(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setSprinting(boolean sprinting, CallbackInfo ci) {
        if (sprinting && ((class_1309)this).method_6059(SpectrumStatusEffects.SCARRED)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"applyFoodEffects(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V"})
    public void eat(class_1799 stack, class_1937 world, class_1309 targetEntity, CallbackInfo ci) {
        class_1792 item = stack.method_7909();
        if (item instanceof ApplyFoodEffectsCallback) {
            ApplyFoodEffectsCallback foodWithCallback = (ApplyFoodEffectsCallback)item;
            foodWithCallback.afterConsumption(world, stack, (class_1309)this);
        }
    }

    @Inject(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")}, cancellable=true)
    public void spectrum$addStackableStatusEffect(class_1293 effect, class_1297 source, CallbackInfoReturnable<Boolean> cir) {
        if (effect.method_5579() instanceof StackableStatusEffect) {
            if (!SpectrumStatusEffects.effectsAreGettingStacked) {
                if (this.method_6049(effect)) {
                    class_1293 existingInstance = this.method_6112(effect.method_5579());
                    if (existingInstance != null) {
                        SpectrumStatusEffects.effectsAreGettingStacked = true;
                        int newAmplifier = 1 + existingInstance.method_5578() + effect.method_5578();
                        class_1293 newInstance = new class_1293(existingInstance.method_5579(), existingInstance.method_5584(), newAmplifier, existingInstance.method_5591(), existingInstance.method_5581(), existingInstance.method_5592());
                        this.method_6016(existingInstance.method_5579());
                        this.method_6092(newInstance);
                        cir.cancel();
                    }
                } else {
                    SpectrumStatusEffects.effectsAreGettingStacked = false;
                }
            } else {
                SpectrumStatusEffects.effectsAreGettingStacked = false;
            }
        }
    }
}

