/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1766.class})
public abstract class MiningToolItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"postMine(Lnet/minecraft/item/ItemStack;Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/LivingEntity;)Z"})
    public void countInertiaBlocks(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner, CallbackInfoReturnable<Boolean> cir) {
        if (stack != null) {
            long inertiaAmount = 0L;
            if (SpectrumEnchantmentHelper.getUsableLevel(SpectrumEnchantments.INERTIA, stack, (class_1297)miner) > 0) {
                class_2487 compound = stack.method_7948();
                class_2960 brokenBlockIdentifier = class_2378.field_11146.method_10221((Object)state.method_26204());
                if (compound.method_10558("Inertia_LastMinedBlock").equals(brokenBlockIdentifier.toString())) {
                    inertiaAmount = compound.method_10537("Inertia_LastMinedBlockCount") + 1L;
                    compound.method_10544("Inertia_LastMinedBlockCount", inertiaAmount);
                } else {
                    compound.method_10582("Inertia_LastMinedBlock", brokenBlockIdentifier.toString());
                    compound.method_10544("Inertia_LastMinedBlockCount", 1L);
                    inertiaAmount = 1L;
                }
            }
            if (miner instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)miner;
                SpectrumAdvancementCriteria.INERTIA_USED.trigger(serverPlayerEntity, state, (int)inertiaAmount);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getMiningSpeedMultiplier(Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/BlockState;)F"}, cancellable=true)
    public void applyInertiaMiningSpeedMultiplier(class_1799 stack, class_2680 state, CallbackInfoReturnable<Float> cir) {
        if (stack != null) {
            int inertiaLevel = class_1890.method_8225((class_1887)SpectrumEnchantments.INERTIA, (class_1799)stack);
            if ((inertiaLevel = Math.min(4, inertiaLevel)) > 0) {
                class_2487 compound = stack.method_7948();
                class_2960 brokenBlockIdentifier = class_2378.field_11146.method_10221((Object)state.method_26204());
                if (compound.method_10558("Inertia_LastMinedBlock").equals(brokenBlockIdentifier.toString())) {
                    long lastMinedBlockCount = compound.method_10537("Inertia_LastMinedBlockCount");
                    double additionalSpeedPercent = 1.5 * Math.log(lastMinedBlockCount) / Math.log((6 - inertiaLevel) * (6 - inertiaLevel) + 1);
                    cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * (0.5f + (float)additionalSpeedPercent)));
                } else {
                    cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() / 4.0f));
                }
            }
        }
    }
}

