/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.cca.HardcoreDeathComponent;
import de.dafuqs.spectrum.enchantments.DisarmingEnchantment;
import de.dafuqs.spectrum.enchantments.TreasureHunterEnchantment;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.items.trinkets.GleamingPinItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin {
    private long spectrum$lastGleamingPinTriggerTick = 0L;

    @Shadow
    public abstract class_3218 method_14220();

    @Shadow
    public abstract void method_14226();

    @Inject(at={@At(value="HEAD")}, method={"onDeath(Lnet/minecraft/entity/damage/DamageSource;)V"})
    protected void spectrum$dropPlayerHeadWithTreasureHunt(class_1282 source, CallbackInfo ci) {
        TreasureHunterEnchantment.doTreasureHunterForPlayer((class_3222)this, source);
    }

    @Inject(at={@At(value="TAIL")}, method={"onDeath(Lnet/minecraft/entity/damage/DamageSource;)V"})
    protected void spectrum$onDeath(class_1282 source, CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player.method_14220().method_8401().method_152() || HardcoreDeathComponent.isInHardcore((class_1657)player)) {
            HardcoreDeathComponent.addHardcoreDeath(player.method_7334());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void spectrum$damageHead(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.equals(class_1282.field_5863)) {
            class_1657 thisEntity = (class_1657)this;
            Optional<class_1799> ashenCircletStack = SpectrumTrinketItem.getFirstEquipped((class_1309)thisEntity, SpectrumItems.ASHEN_CIRCLET);
            if (ashenCircletStack.isPresent() && AshenCircletItem.getCooldownTicks(ashenCircletStack.get(), thisEntity.field_6002) == 0L) {
                AshenCircletItem.grantFireResistance(ashenCircletStack.get(), (class_1309)thisEntity);
            }
        } else if (source.method_5534() && SpectrumTrinketItem.hasEquipped((class_1309)((class_1657)this), SpectrumItems.ASHEN_CIRCLET)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"})
    public void spectrum$damageReturn(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972;
        if (!this.method_14220().field_9236 && cir.getReturnValue() != null && ((Boolean)cir.getReturnValue()).booleanValue() && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 livingSource = (class_1309)class_12972;
            class_3222 thisPlayer = (class_3222)this;
            int disarmingLevel = SpectrumEnchantmentHelper.getUsableLevel(SpectrumEnchantments.DISARMING, livingSource.method_6047(), (class_1297)livingSource);
            if (disarmingLevel > 0 && Math.random() < (double)((float)disarmingLevel * SpectrumCommon.CONFIG.DisarmingChancePerLevelPlayers)) {
                DisarmingEnchantment.disarmPlayer((class_1657)thisPlayer);
            }
            class_3218 world = thisPlayer.method_14220();
            Optional<class_1799> gleamingPinStack = SpectrumTrinketItem.getFirstEquipped((class_1309)thisPlayer, SpectrumItems.GLEAMING_PIN);
            if (gleamingPinStack.isPresent() && world.method_8510() - this.spectrum$lastGleamingPinTriggerTick > 160L) {
                GleamingPinItem.doGleamingPinEffect((class_1657)thisPlayer, world, gleamingPinStack.get());
                this.spectrum$lastGleamingPinTriggerTick = world.method_8510();
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"updateKilledAdvancementCriterion(Lnet/minecraft/entity/Entity;ILnet/minecraft/entity/damage/DamageSource;)V"})
    public void spectrum$triggerJeopardantKillAdvancementCriterion(class_1297 killed, int score, class_1282 damageSource, CallbackInfo ci) {
        if (killed != this && SpectrumTrinketItem.hasEquipped(this, SpectrumItems.JEOPARDANT)) {
            SpectrumAdvancementCriteria.JEOPARDANT_KILL.trigger((class_3222)this, killed, damageSource);
        }
    }
}

