/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin.client;

import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.magic_items.PlacementStaffItem;
import de.dafuqs.spectrum.mixin.accessors.WorldRendererAccessor;
import de.dafuqs.spectrum.render.HudRenderers;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import oshi.util.tuples.Triplet;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private class_638 field_4085;
    @Unique
    private boolean renderedExtendedOutline = false;

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;FJZLnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/GameRenderer;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/util/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/hit/HitResult;getType()Lnet/minecraft/util/hit/HitResult$Type;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void renderExtendedBlockOutline(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, class_1159 positionMatrix, CallbackInfo ci, class_3695 profiler, boolean b, class_243 vec3d, double d, double e, double f, class_1159 matrix4f2, boolean b2, class_4604 frustum2, float g, boolean b25, boolean b3, class_4597.class_4598 immediate) {
        this.renderedExtendedOutline = false;
        HudRenderers.doNotRenderOverlay();
        if (this.field_4088.field_1724 != null && renderBlockOutline) {
            for (class_1799 handStack : this.field_4088.field_1724.method_5877()) {
                class_1792 handItem = handStack.method_7909();
                if (handItem instanceof PlacementStaffItem) {
                    class_239 hitResult = this.field_4088.field_1765;
                    if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) break;
                    this.renderedExtendedOutline = this.renderPlacementStaffOutline(matrices, camera, d, e, f, immediate, (class_3965)hitResult);
                    break;
                }
                if (!(handItem instanceof ExchangeStaffItem)) continue;
                class_239 hitResult = this.field_4088.field_1765;
                if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) break;
                this.renderedExtendedOutline = this.renderExchangeStaffOutline(matrices, camera, d, e, f, immediate, handStack, (class_3965)hitResult);
                break;
            }
        }
    }

    private boolean renderPlacementStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597.class_4598 immediate, @NotNull class_3965 hitResult) {
        class_2338 lookingAtPos = hitResult.method_17777();
        class_2680 lookingAtState = this.field_4085.method_8320(lookingAtPos);
        class_746 player = this.field_4088.field_1724;
        if (player.method_7337() || !BuildingStaffItem.isBlacklisted(lookingAtState)) {
            class_2248 lookingAtBlock = lookingAtState.method_26204();
            class_1792 item = lookingAtBlock.method_8389();
            class_265 shape = class_259.method_1073();
            if (item != class_1802.field_8162) {
                int itemCountInInventory = Integer.MAX_VALUE;
                int inkLimit = Integer.MAX_VALUE;
                if (!player.method_7337()) {
                    Triplet<class_2248, class_1792, Integer> inventoryItemAndCount = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars((class_1657)player, lookingAtBlock);
                    item = (class_1792)inventoryItemAndCount.getB();
                    itemCountInInventory = (Integer)inventoryItemAndCount.getC();
                    inkLimit = (int)InkPowered.getAvailableInk((class_1657)player, PlacementStaffItem.USED_COLOR) / 1;
                }
                boolean sneaking = player.method_5715();
                if (itemCountInInventory == 0) {
                    HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 0, false);
                } else if (inkLimit == 0) {
                    HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 1, true);
                } else {
                    int usableCount = Math.min(itemCountInInventory, inkLimit);
                    List<class_2338> positions = BuildingHelper.calculateBuildingStaffSelection((class_1937)this.field_4085, lookingAtPos, hitResult.method_17780(), usableCount, PlacementStaffItem.getRange((class_1657)player), !sneaking);
                    if (positions.size() > 0) {
                        for (class_2338 newPosition : positions) {
                            if (!this.field_4085.method_8621().method_11952(newPosition)) continue;
                            class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                            shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)this.field_4085, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                        }
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)item), positions.size(), false);
                        class_4588 linesBuffer = immediate.getBuffer(class_1921.method_23594());
                        WorldRendererAccessor.invokeDrawCuboidShapeOutline(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean renderExchangeStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597.class_4598 immediate, class_1799 exchangeStaffItemStack, @NotNull class_3965 hitResult) {
        class_2338 lookingAtPos = hitResult.method_17777();
        class_2680 lookingAtState = this.field_4085.method_8320(lookingAtPos);
        class_746 player = this.field_4088.field_1724;
        if (player.method_7337() || !BuildingStaffItem.isBlacklisted(lookingAtState)) {
            class_2248 lookingAtBlock = lookingAtState.method_26204();
            Optional<class_2248> exchangeBlock = ExchangeStaffItem.getBlockTarget(exchangeStaffItemStack);
            if (exchangeBlock.isPresent() && exchangeBlock.get() != lookingAtBlock) {
                class_1792 exchangeBlockItem = exchangeBlock.get().method_8389();
                class_265 shape = class_259.method_1073();
                if (exchangeBlockItem != class_1802.field_8162) {
                    int itemCountInInventory = Integer.MAX_VALUE;
                    int inkLimit = Integer.MAX_VALUE;
                    if (!player.method_7337()) {
                        itemCountInInventory = player.method_31548().method_18861(exchangeBlockItem);
                        inkLimit = (int)InkPowered.getAvailableInk((class_1657)player, ExchangeStaffItem.USED_COLOR) / 5;
                    }
                    if (itemCountInInventory == 0) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 0, false);
                    } else if (inkLimit == 0) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 1, true);
                    } else {
                        int usableCount = Math.min(itemCountInInventory, inkLimit);
                        List<class_2338> positions = BuildingHelper.getConnectedBlocks((class_1937)this.field_4085, lookingAtPos, usableCount, ExchangeStaffItem.getRange((class_1657)player));
                        for (class_2338 newPosition : positions) {
                            if (!this.field_4085.method_8621().method_11952(newPosition)) continue;
                            class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                            shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)this.field_4085, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                        }
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), positions.size(), false);
                        class_4588 linesBuffer = immediate.getBuffer(class_1921.method_23594());
                        WorldRendererAccessor.invokeDrawCuboidShapeOutline(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Inject(method={"drawBlockOutline(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/entity/Entity;DDDLnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelDrawBlockOutlineIfLargerOneIsDrawnInstead(class_4587 matrixStack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState, CallbackInfo ci) {
        if (this.renderedExtendedOutline) {
            ci.cancel();
        }
    }
}

