/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.items.magic_items.PaintbrushItem;
import de.dafuqs.spectrum.progression.toast.MessageToast;
import de.dafuqs.spectrum.progression.toast.UnlockedRecipeGroupToast;
import de.dafuqs.spectrum.recipe.GatedRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class UnlockToastManager {
    public static final Map<class_2960, Map<class_3956, List<GatedRecipe>>> gatedRecipes = new HashMap<class_2960, Map<class_3956, List<GatedRecipe>>>();
    public static final HashMap<class_2960, class_3545<class_1799, String>> messageToasts = new HashMap<class_2960, class_3545<class_1799, String>>(){
        {
            this.put(SpectrumCommon.locate("milestones/unlock_shooting_stars"), new class_3545((Object)class_1802.field_27070.method_7854(), (Object)"shooting_stars_unlocked"));
            this.put(SpectrumCommon.locate("milestones/unlock_overenchanting_with_enchanter"), new class_3545((Object)SpectrumBlocks.ENCHANTER.method_8389().method_7854(), (Object)"overchanting_unlocked"));
            this.put(SpectrumCommon.locate("milestones/unlock_conflicted_enchanting_with_enchanter"), new class_3545((Object)SpectrumBlocks.ENCHANTER.method_8389().method_7854(), (Object)"enchant_conflicting_enchantments_unlocked"));
            this.put(SpectrumCommon.locate("milestones/unlock_fourth_potion_workshop_reagent_slot"), new class_3545((Object)SpectrumBlocks.POTION_WORKSHOP.method_8389().method_7854(), (Object)"fourth_potion_reagent_unlocked"));
            this.put(SpectrumCommon.locate("midgame/spectrum_midgame"), new class_3545((Object)SpectrumBlocks.PEDESTAL_ONYX.method_8389().method_7854(), (Object)"second_advancement_tree_unlocked"));
            this.put(SpectrumCommon.locate("lategame/spectrum_lategame"), new class_3545((Object)SpectrumBlocks.PEDESTAL_MOONSTONE.method_8389().method_7854(), (Object)"third_advancement_tree_unlocked"));
            this.put(PaintbrushItem.UNLOCK_COLORING_ADVANCEMENT_ID, new class_3545((Object)SpectrumItems.PAINTBRUSH.method_7854(), (Object)"block_coloring_unlocked"));
            this.put(PaintbrushItem.UNLOCK_INK_SLINGING_ADVANCEMENT_ID, new class_3545((Object)SpectrumItems.PAINTBRUSH.method_7854(), (Object)"paint_flinging_unlocked"));
        }
    };

    public static void registerGatedRecipe(class_3956 recipeType, GatedRecipe gatedRecipe) {
        class_2960 requiredAdvancementIdentifier = gatedRecipe.getRequiredAdvancementIdentifier();
        if (gatedRecipes.containsKey(requiredAdvancementIdentifier)) {
            Map<class_3956, List<GatedRecipe>> recipeTypeListMap = gatedRecipes.get(requiredAdvancementIdentifier);
            if (recipeTypeListMap.containsKey(recipeType)) {
                List<GatedRecipe> existingList = recipeTypeListMap.get(recipeType);
                if (!existingList.contains(gatedRecipe)) {
                    existingList.add(gatedRecipe);
                }
            } else {
                ArrayList<GatedRecipe> newList = new ArrayList<GatedRecipe>();
                newList.add(gatedRecipe);
                recipeTypeListMap.put(recipeType, newList);
            }
        } else {
            HashMap recipeTypeListMap = new HashMap();
            ArrayList<GatedRecipe> newList = new ArrayList<GatedRecipe>();
            newList.add(gatedRecipe);
            recipeTypeListMap.put(recipeType, newList);
            gatedRecipes.put(requiredAdvancementIdentifier, recipeTypeListMap);
        }
    }

    public static void processAdvancements(Set<class_2960> doneAdvancements) {
        HashMap<class_3956, List<GatedRecipe>> unlockedRecipesByType = new HashMap<class_3956, List<GatedRecipe>>();
        ArrayList<class_3545<class_1799, String>> specialToasts = new ArrayList<class_3545<class_1799, String>>();
        for (class_2960 class_29602 : doneAdvancements) {
            Optional<PedestalRecipeTier> newlyUnlockedRecipeTier;
            if (gatedRecipes.containsKey(class_29602)) {
                Map<class_3956, List<GatedRecipe>> recipesGatedByAdvancement = gatedRecipes.get(class_29602);
                for (Map.Entry<class_3956, List<GatedRecipe>> recipesByType : recipesGatedByAdvancement.entrySet()) {
                    List newRecipes = unlockedRecipesByType.containsKey(recipesByType.getKey()) ? (List)unlockedRecipesByType.get(recipesByType.getKey()) : new ArrayList();
                    for (GatedRecipe unlockedRecipe : recipesByType.getValue()) {
                        if (!unlockedRecipe.canPlayerCraft((class_1657)class_310.method_1551().field_1724) || newRecipes.contains(unlockedRecipe)) continue;
                        newRecipes.add(unlockedRecipe);
                    }
                    unlockedRecipesByType.put(recipesByType.getKey(), newRecipes);
                }
            }
            if ((newlyUnlockedRecipeTier = PedestalRecipeTier.hasJustUnlockedANewRecipeTier(class_29602)).isPresent()) {
                List unlockedPedestalRecipes = unlockedRecipesByType.containsKey(SpectrumRecipeTypes.PEDESTAL) ? (List)unlockedRecipesByType.get(SpectrumRecipeTypes.PEDESTAL) : new ArrayList();
                ArrayList<GatedRecipe> pedestalRecipes = new ArrayList<GatedRecipe>();
                for (Map<class_3956, List<GatedRecipe>> recipesByType : gatedRecipes.values()) {
                    if (!recipesByType.containsKey(SpectrumRecipeTypes.PEDESTAL)) continue;
                    pedestalRecipes.addAll((Collection<GatedRecipe>)recipesByType.get(SpectrumRecipeTypes.PEDESTAL));
                }
                for (PedestalCraftingRecipe alreadyUnlockedRecipe : UnlockToastManager.getRecipesForTierWithAllConditionsMet(newlyUnlockedRecipeTier.get(), pedestalRecipes)) {
                    if (unlockedPedestalRecipes.contains(alreadyUnlockedRecipe)) continue;
                    unlockedPedestalRecipes.add(alreadyUnlockedRecipe);
                }
            }
            if (!messageToasts.containsKey(class_29602)) continue;
            specialToasts.add(messageToasts.get(class_29602));
        }
        for (List list : unlockedRecipesByType.values()) {
            UnlockToastManager.showGroupedRecipeUnlockToasts(list);
        }
        for (class_3545 class_35452 : specialToasts) {
            MessageToast.showMessageToast(class_310.method_1551(), (class_1799)class_35452.method_15442(), (String)class_35452.method_15441());
        }
    }

    private static void showGroupedRecipeUnlockToasts(List<GatedRecipe> unlockedRecipes) {
        if (!unlockedRecipes.isEmpty()) {
            class_2561 singleText = unlockedRecipes.get(0).getSingleUnlockToastString();
            class_2561 multipleText = unlockedRecipes.get(0).getMultipleUnlockToastString();
            HashMap groupedRecipes = new HashMap();
            for (GatedRecipe recipe : unlockedRecipes) {
                if (recipe.method_8110().method_7960()) continue;
                if (recipe.method_8112() == null) {
                    SpectrumCommon.logWarning("Found a recipe with null group: " + recipe.method_8114().toString() + " Please report this. If you are Dafuqs and you are reading this: you messed up big time.");
                }
                if (recipe.method_8112().isEmpty()) {
                    class_1799 displayStack = recipe.method_8110().method_7972();
                    displayStack.method_7939(1);
                    UnlockedRecipeGroupToast.showRecipeToast(class_310.method_1551(), displayStack, singleText);
                    continue;
                }
                if (groupedRecipes.containsKey(recipe.method_8112())) {
                    ((List)groupedRecipes.get(recipe.method_8112())).add(recipe.method_8110());
                    continue;
                }
                ArrayList<class_1799> newList = new ArrayList<class_1799>();
                newList.add(new class_1799((class_1935)recipe.method_8110().method_7909()));
                groupedRecipes.put(recipe.method_8112(), newList);
            }
            if (!groupedRecipes.isEmpty()) {
                for (String group : groupedRecipes.keySet()) {
                    List groupedList = (List)groupedRecipes.get(group);
                    if (groupedList.size() == 1) {
                        UnlockedRecipeGroupToast.showRecipeToast(class_310.method_1551(), (class_1799)groupedList.get(0), singleText);
                        continue;
                    }
                    UnlockedRecipeGroupToast.showRecipeGroupToast(class_310.method_1551(), group, (List)groupedRecipes.get(group), multipleText);
                }
            }
        }
    }

    @NotNull
    private static List<PedestalCraftingRecipe> getRecipesForTierWithAllConditionsMet(PedestalRecipeTier pedestalRecipeTier, List<GatedRecipe> pedestalRecipes) {
        class_746 player = class_310.method_1551().field_1724;
        ArrayList<PedestalCraftingRecipe> alreadyUnlockedRecipesAtNewTier = new ArrayList<PedestalCraftingRecipe>();
        for (GatedRecipe recipe : pedestalRecipes) {
            PedestalCraftingRecipe pedestalCraftingRecipe = (PedestalCraftingRecipe)recipe;
            if (pedestalCraftingRecipe.getTier() != pedestalRecipeTier || alreadyUnlockedRecipesAtNewTier.contains(recipe) || !recipe.canPlayerCraft((class_1657)player)) continue;
            alreadyUnlockedRecipesAtNewTier.add(pedestalCraftingRecipe);
        }
        return alreadyUnlockedRecipesAtNewTier;
    }
}

