/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4559;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BrokenBlockPredicate {
    public static final BrokenBlockPredicate ANY = new BrokenBlockPredicate(null, null, class_4559.field_20736);
    @Nullable
    private final class_6862<class_2248> tag;
    @Nullable
    private final Set<class_2248> blocks;
    private final class_4559 state;

    public BrokenBlockPredicate(@Nullable class_6862<class_2248> tag, @Nullable Set<class_2248> blocks, class_4559 state) {
        this.tag = tag;
        this.blocks = blocks;
        this.state = state;
    }

    public static BrokenBlockPredicate fromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"block");
            ImmutableSet set = null;
            JsonArray jsonArray = class_3518.method_15292((JsonObject)jsonObject, (String)"blocks", null);
            if (jsonArray != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (JsonElement jsonElement : jsonArray) {
                    class_2960 identifier = new class_2960(class_3518.method_15287((JsonElement)jsonElement, (String)"block"));
                    builder.add((Object)((class_2248)class_2378.field_11146.method_17966(identifier).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + identifier + "'"))));
                }
                set = builder.build();
            }
            class_6862 tag = null;
            if (jsonObject.has("tag")) {
                class_2960 identifier2 = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"tag"));
                tag = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)identifier2);
            }
            class_4559 statePredicate = class_4559.method_22519((JsonElement)jsonObject.get("state"));
            return new BrokenBlockPredicate((class_6862<class_2248>)tag, (Set<class_2248>)set, statePredicate);
        }
        return ANY;
    }

    public boolean test(class_2680 blockState) {
        if (this == ANY) {
            return true;
        }
        if (this.tag != null && !blockState.method_26164(this.tag)) {
            return false;
        }
        if (this.blocks != null && !this.blocks.contains(blockState.method_26204())) {
            return false;
        }
        return this.state.method_22514(blockState);
    }

    public JsonElement toJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.blocks != null) {
            JsonArray jsonArray = new JsonArray();
            for (class_2248 block : this.blocks) {
                jsonArray.add(class_2378.field_11146.method_10221((Object)block).toString());
            }
            jsonObject.add("blocks", (JsonElement)jsonArray);
        }
        if (this.tag != null) {
            jsonObject.addProperty("tag", this.tag.comp_327().toString());
        }
        jsonObject.add("state", this.state.method_22513());
        return jsonObject;
    }

    public static class Builder {
        @Nullable
        private Set<class_2248> blocks;
        @Nullable
        private class_6862<class_2248> tag;
        private class_4559 state = class_4559.field_20736;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder blocks(class_2248 ... blocks) {
            this.blocks = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder blocks(Iterable<class_2248> blocks) {
            this.blocks = ImmutableSet.copyOf(blocks);
            return this;
        }

        public Builder tag(class_6862<class_2248> tag) {
            this.tag = tag;
            return this;
        }

        public Builder state(class_4559 state) {
            this.state = state;
            return this;
        }

        public BrokenBlockPredicate build() {
            return new BrokenBlockPredicate(this.tag, this.blocks, this.state);
        }
    }
}

