/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class TrinketChangeCriterion
extends class_4558<Conditions> {
    static final class_2960 ID = SpectrumCommon.locate("trinket_change");

    public class_2960 method_794() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject jsonObject, class_2048.class_5258 extended, class_5257 advancementEntityPredicateDeserializer) {
        class_2073[] itemPredicates = class_2073.method_8972((JsonElement)jsonObject.get("items"));
        class_2096.class_2100 totalCountRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("total_count"));
        class_2096.class_2100 spectrumCountRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("spectrum_count"));
        return new Conditions(extended, itemPredicates, totalCountRange, spectrumCountRange);
    }

    public void trigger(class_3222 player) {
        this.method_22510(player, conditions -> {
            Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
            if (trinketComponent.isPresent()) {
                ArrayList<class_1799> equippedStacks = new ArrayList<class_1799>();
                int spectrumStacks = 0;
                for (class_3545 t : ((TrinketComponent)trinketComponent.get()).getAllEquipped()) {
                    equippedStacks.add((class_1799)t.method_15441());
                    if (!(((class_1799)t.method_15441()).method_7909() instanceof SpectrumTrinketItem)) continue;
                    ++spectrumStacks;
                }
                return conditions.matches(equippedStacks, equippedStacks.size(), spectrumStacks);
            }
            return false;
        });
    }

    public static class Conditions
    extends class_195 {
        private final class_2073[] itemPredicates;
        private final class_2096.class_2100 totalCountRange;
        private final class_2096.class_2100 spectrumCountRange;

        public Conditions(class_2048.class_5258 player, class_2073[] itemPredicates, class_2096.class_2100 totalCountRange, class_2096.class_2100 spectrumCountRange) {
            super(ID, player);
            this.itemPredicates = itemPredicates;
            this.totalCountRange = totalCountRange;
            this.spectrumCountRange = spectrumCountRange;
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            JsonObject jsonObject = super.method_807(predicateSerializer);
            if (this.itemPredicates.length > 0) {
                JsonArray jsonObject2 = new JsonArray();
                for (class_2073 itemPredicate : this.itemPredicates) {
                    jsonObject2.add(itemPredicate.method_8971());
                }
                jsonObject.add("items", (JsonElement)jsonObject2);
            }
            jsonObject.add("total_count", this.totalCountRange.method_9036());
            jsonObject.add("spectrum_count", this.spectrumCountRange.method_9036());
            return jsonObject;
        }

        public boolean matches(List<class_1799> trinketStacks, int totalCount, int spectrumCount) {
            if (this.totalCountRange.method_9054(totalCount) && this.spectrumCountRange.method_9054(spectrumCount)) {
                int i = this.itemPredicates.length;
                if (i == 0) {
                    return true;
                }
                if (i != 1) {
                    ObjectArrayList list = new ObjectArrayList((Object[])this.itemPredicates);
                    for (class_1799 trinketStack : trinketStacks) {
                        if (list.isEmpty()) {
                            return true;
                        }
                        if (trinketStack.method_7960()) continue;
                        list.removeIf(item -> item.method_8970(trinketStack));
                    }
                    return list.isEmpty();
                }
            }
            return false;
        }
    }
}

