/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.cinderhearth;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.cinderhearth.CinderhearthRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;

public class CinderhearthRecipeSerializer
implements GatedRecipeSerializer<CinderhearthRecipe> {
    public final RecipeFactory<CinderhearthRecipe> recipeFactory;

    public CinderhearthRecipeSerializer(RecipeFactory<CinderhearthRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public CinderhearthRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_1856 inputIngredient = class_1856.method_8102((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient"));
        int time = class_3518.method_15260((JsonObject)jsonObject, (String)"time");
        float experience = class_3518.method_15259((JsonObject)jsonObject, (String)"experience");
        ArrayList<class_3545<class_1799, Float>> outputsWithChance = new ArrayList<class_3545<class_1799, Float>>();
        for (JsonElement outputEntry : class_3518.method_15261((JsonObject)jsonObject, (String)"results")) {
            JsonObject outputObject = outputEntry.getAsJsonObject();
            class_1799 outputStack = RecipeUtils.itemStackWithNbtFromJson(outputObject);
            float outputChance = 1.0f;
            if (class_3518.method_34920((JsonObject)outputObject, (String)"chance")) {
                outputChance = class_3518.method_15259((JsonObject)outputObject, (String)"chance");
            }
            outputsWithChance.add((class_3545<class_1799, Float>)new class_3545((Object)outputStack, (Object)Float.valueOf(outputChance)));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, inputIngredient, time, experience, outputsWithChance);
    }

    public void write(class_2540 packetByteBuf, CinderhearthRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        recipe.inputIngredient.method_8088(packetByteBuf);
        packetByteBuf.writeInt(recipe.time);
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeInt(recipe.outputsWithChance.size());
        for (class_3545<class_1799, Float> output : recipe.outputsWithChance) {
            packetByteBuf.method_10793((class_1799)output.method_15442());
            packetByteBuf.writeFloat(((Float)output.method_15441()).floatValue());
        }
    }

    public CinderhearthRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        class_1856 inputIngredient = class_1856.method_8086((class_2540)packetByteBuf);
        int time = packetByteBuf.readInt();
        float experience = packetByteBuf.readFloat();
        int outputCount = packetByteBuf.readInt();
        ArrayList<class_3545<class_1799, Float>> outputsWithChance = new ArrayList<class_3545<class_1799, Float>>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            outputsWithChance.add(new class_3545((Object)packetByteBuf.method_10819(), (Object)Float.valueOf(packetByteBuf.readFloat())));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, inputIngredient, time, experience, outputsWithChance);
    }

    public static interface RecipeFactory<CinderhearthRecipe> {
        public CinderhearthRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_1856 var5, int var6, float var7, List<class_3545<class_1799, Float>> var8);
    }
}

