/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.crystallarieum;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumRecipe
extends GatedSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("progression/unlock_crystallarieum");
    protected final class_1856 inputIngredient;
    protected final List<class_2680> growthStages;
    protected final int secondsPerGrowthStage;
    protected final InkColor inkColor;
    protected final int inkPerSecond;
    protected final boolean growsWithoutCatalyst;
    protected final List<CrystallarieumCatalyst> catalysts;
    protected static final Map<class_1856, CrystallarieumRecipe> ingredientMap = new HashMap<class_1856, CrystallarieumRecipe>();
    protected static final Map<class_2680, CrystallarieumRecipe> stateMap = new HashMap<class_2680, CrystallarieumRecipe>();

    public CrystallarieumRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, class_1856 inputIngredient, List<class_2680> growthStages, int secondsPerGrowthStage, InkColor inkColor, int inkPerSecond, boolean growsWithoutCatalyst, List<CrystallarieumCatalyst> catalysts) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.inputIngredient = inputIngredient;
        this.growthStages = growthStages;
        this.secondsPerGrowthStage = secondsPerGrowthStage;
        this.inkColor = inkColor;
        this.inkPerSecond = inkPerSecond;
        this.growsWithoutCatalyst = growsWithoutCatalyst;
        this.catalysts = catalysts;
        ingredientMap.put(inputIngredient, this);
        for (class_2680 growthStage : growthStages) {
            stateMap.put(growthStage, this);
        }
        this.registerInToastManager(this.method_17716(), this);
    }

    @Nullable
    public static CrystallarieumRecipe getRecipeForStack(class_1799 itemStack) {
        for (Map.Entry<class_1856, CrystallarieumRecipe> entry : ingredientMap.entrySet()) {
            if (!entry.getKey().method_8093(itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static CrystallarieumRecipe getRecipeForState(class_2680 state) {
        return stateMap.getOrDefault(state, null);
    }

    public static void clearCache() {
        ingredientMap.clear();
        stateMap.clear();
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.inputIngredient.method_8093(inv.method_5438(0));
    }

    public class_1799 method_8116(class_1263 inv) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        List<class_2680> states = this.getGrowthStages();
        return states.get(states.size() - 1).method_26204().method_8389().method_7854();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.CRYSTALLARIEUM);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.CRYSTALLARIEUM_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.CRYSTALLARIEUM;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "crystallarieum_growing";
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.inputIngredient);
        return defaultedList;
    }

    public class_1856 getIngredientStack() {
        return this.inputIngredient;
    }

    public Optional<CrystallarieumCatalyst> getCatalyst(class_1799 itemStack) {
        for (CrystallarieumCatalyst catalyst : this.catalysts) {
            if (!catalyst.ingredient.method_8093(itemStack)) continue;
            return Optional.of(catalyst);
        }
        return Optional.empty();
    }

    public List<class_2680> getGrowthStages() {
        return this.growthStages;
    }

    public int getSecondsPerGrowthStage() {
        return this.secondsPerGrowthStage;
    }

    public InkColor getInkColor() {
        return this.inkColor;
    }

    public int getInkPerSecond() {
        return this.inkPerSecond;
    }

    public boolean growsWithoutCatalyst() {
        return this.growsWithoutCatalyst;
    }

    public List<CrystallarieumCatalyst> getCatalysts() {
        return this.catalysts;
    }
}

