/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.crystallarieum;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CrystallarieumRecipeSerializer
implements GatedRecipeSerializer<CrystallarieumRecipe> {
    public final RecipeFactory<CrystallarieumRecipe> recipeFactory;

    public CrystallarieumRecipeSerializer(RecipeFactory<CrystallarieumRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public CrystallarieumRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_1856 inputIngredient = class_1856.method_8102((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient"));
        ArrayList<class_2680> growthStages = new ArrayList<class_2680>();
        JsonArray growthStageArray = class_3518.method_15261((JsonObject)jsonObject, (String)"growth_stage_states");
        for (int i = 0; i < growthStageArray.size(); ++i) {
            String blockStateString = growthStageArray.get(i).getAsString();
            try {
                growthStages.add(RecipeUtils.blockStateFromString(blockStateString));
                continue;
            }
            catch (CommandSyntaxException e) {
                SpectrumCommon.logError("Recipe " + identifier + " specifies block state " + blockStateString + " that does not seem valid or the block does not exist. Recipe will be ignored.");
                return null;
            }
        }
        int secondsPerGrowthStage = class_3518.method_15260((JsonObject)jsonObject, (String)"seconds_per_growth_stage");
        InkColor inkColor = InkColor.of(class_3518.method_15265((JsonObject)jsonObject, (String)"ink_color"));
        int inkPerSecond = class_3518.method_15260((JsonObject)jsonObject, (String)"ink_per_second");
        boolean growsWithoutCatalyst = class_3518.method_15270((JsonObject)jsonObject, (String)"grows_without_catalyst");
        ArrayList<CrystallarieumCatalyst> catalysts = new ArrayList<CrystallarieumCatalyst>();
        JsonArray catalystArray = class_3518.method_15261((JsonObject)jsonObject, (String)"catalysts");
        for (int i = 0; i < catalystArray.size(); ++i) {
            catalysts.add(CrystallarieumCatalyst.fromJson(catalystArray.get(i).getAsJsonObject()));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, inputIngredient, growthStages, secondsPerGrowthStage, inkColor, inkPerSecond, growsWithoutCatalyst, catalysts);
    }

    public void write(class_2540 packetByteBuf, CrystallarieumRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        recipe.inputIngredient.method_8088(packetByteBuf);
        packetByteBuf.writeInt(recipe.growthStages.size());
        for (class_2680 state : recipe.growthStages) {
            packetByteBuf.method_10814(RecipeUtils.blockStateToString(state));
        }
        packetByteBuf.writeInt(recipe.secondsPerGrowthStage);
        packetByteBuf.method_10814(recipe.inkColor.toString());
        packetByteBuf.writeInt(recipe.inkPerSecond);
        packetByteBuf.writeBoolean(recipe.growsWithoutCatalyst);
        packetByteBuf.writeInt(recipe.catalysts.size());
        for (CrystallarieumCatalyst catalyst : recipe.catalysts) {
            catalyst.write(packetByteBuf);
        }
    }

    public CrystallarieumRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        class_1856 inputIngredient = class_1856.method_8086((class_2540)packetByteBuf);
        ArrayList<class_2680> growthStages = new ArrayList<class_2680>();
        int count = packetByteBuf.readInt();
        for (int i = 0; i < count; ++i) {
            String blockStateString = packetByteBuf.method_19772();
            try {
                growthStages.add(RecipeUtils.blockStateFromString(blockStateString));
                continue;
            }
            catch (CommandSyntaxException e) {
                SpectrumCommon.logError("Recipe " + identifier + " specifies block state " + blockStateString + " that does not seem valid or the block does not exist. Recipe will be ignored.");
                return null;
            }
        }
        int secondsPerGrowthStage = packetByteBuf.readInt();
        InkColor inkColor = InkColor.of(packetByteBuf.method_19772());
        int inkPerSecond = packetByteBuf.readInt();
        boolean growthWithoutCatalyst = packetByteBuf.readBoolean();
        ArrayList<CrystallarieumCatalyst> catalysts = new ArrayList<CrystallarieumCatalyst>();
        count = packetByteBuf.readInt();
        for (int i = 0; i < count; ++i) {
            catalysts.add(CrystallarieumCatalyst.fromPacket(packetByteBuf));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, inputIngredient, growthStages, secondsPerGrowthStage, inkColor, inkPerSecond, growthWithoutCatalyst, catalysts);
    }

    public static interface RecipeFactory<CrystallarieumRecipe> {
        public CrystallarieumRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_1856 var5, List<class_2680> var6, int var7, InkColor var8, int var9, boolean var10, List<CrystallarieumCatalyst> var11);
    }
}

