/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchanter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class EnchanterRecipeSerializer
implements GatedRecipeSerializer<EnchanterRecipe> {
    public final RecipeFactory<EnchanterRecipe> recipeFactory;

    public EnchanterRecipeSerializer(RecipeFactory<EnchanterRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public EnchanterRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        class_2371 craftingInputs = class_2371.method_37434((int)ingredientArray.size());
        for (int i = 0; i < ingredientArray.size(); ++i) {
            craftingInputs.add((Object)class_1856.method_8102((JsonElement)ingredientArray.get(i)));
        }
        class_1799 output = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        int requiredExperience = class_3518.method_15282((JsonObject)jsonObject, (String)"required_experience", (int)0);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades")) {
            noBenefitsFromYieldAndEfficiencyUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_and_efficiency_upgrades", (boolean)false);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, (class_2371<class_1856>)craftingInputs, output, craftingTime, requiredExperience, noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public void write(class_2540 packetByteBuf, EnchanterRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeShort(recipe.inputs.size());
        for (class_1856 ingredient : recipe.inputs) {
            ingredient.method_8088(packetByteBuf);
        }
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeInt(recipe.requiredExperience);
        packetByteBuf.writeBoolean(recipe.noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public EnchanterRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        short craftingInputCount = packetByteBuf.readShort();
        class_2371 ingredients = class_2371.method_10213((int)craftingInputCount, (Object)class_1856.field_9017);
        for (short i = 0; i < craftingInputCount; i = (short)(i + 1)) {
            ingredients.set((int)i, (Object)class_1856.method_8086((class_2540)packetByteBuf));
        }
        class_1799 output = packetByteBuf.method_10819();
        int craftingTime = packetByteBuf.readInt();
        int requiredExperience = packetByteBuf.readInt();
        boolean noBenefitsFromYieldAndEfficiencyUpgrades = packetByteBuf.readBoolean();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, (class_2371<class_1856>)ingredients, output, craftingTime, requiredExperience, noBenefitsFromYieldAndEfficiencyUpgrades);
    }

    public static interface RecipeFactory<EnchanterRecipe> {
        public EnchanterRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_2371<class_1856> var5, class_1799 var6, int var7, int var8, boolean var9);
    }
}

