/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchantment_upgrade;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class EnchantmentUpgradeRecipeSerializer
implements GatedRecipeSerializer<EnchantmentUpgradeRecipe> {
    public static List<EnchantmentUpgradeRecipe> enchantmentUpgradeRecipesToInject = new ArrayList<EnchantmentUpgradeRecipe>();
    public final RecipeFactory<EnchantmentUpgradeRecipe> recipeFactory;

    public EnchantmentUpgradeRecipeSerializer(RecipeFactory<EnchantmentUpgradeRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public EnchantmentUpgradeRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_2960 enchantmentIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"enchantment"));
        if (!class_2378.field_11160.method_10250(enchantmentIdentifier)) {
            throw new JsonParseException("Enchantment Upgrade Recipe " + identifier + " has an enchantment set that does not exist or is disabled: " + enchantmentIdentifier);
        }
        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(enchantmentIdentifier);
        JsonArray levelArray = class_3518.method_15261((JsonObject)jsonObject, (String)"levels");
        EnchantmentUpgradeRecipe recipe = null;
        for (int i = 0; i < levelArray.size(); ++i) {
            JsonObject currentElement = levelArray.get(i).getAsJsonObject();
            int level = i + 2;
            int requiredExperience = class_3518.method_15260((JsonObject)currentElement, (String)"experience");
            class_1792 requiredItem = (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)currentElement, (String)"item")));
            int requiredItemCount = class_3518.method_15260((JsonObject)currentElement, (String)"item_count");
            recipe = this.recipeFactory.create(SpectrumCommon.locate(identifier.method_12832() + "_level_" + (i + 2)), group, secret, requiredAdvancementIdentifier, enchantment, level, requiredExperience, requiredItem, requiredItemCount);
            if (enchantmentUpgradeRecipesToInject.contains(recipe) || i >= levelArray.size() - 1) continue;
            enchantmentUpgradeRecipesToInject.add(recipe);
        }
        return recipe;
    }

    public void write(class_2540 packetByteBuf, EnchantmentUpgradeRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.method_10812(class_2378.field_11160.method_10221((Object)recipe.enchantment));
        packetByteBuf.writeInt(recipe.enchantmentDestinationLevel);
        packetByteBuf.writeInt(recipe.requiredExperience);
        packetByteBuf.method_10812(class_2378.field_11142.method_10221((Object)recipe.requiredItem));
        packetByteBuf.writeInt(recipe.requiredItemCount);
    }

    public EnchantmentUpgradeRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(packetByteBuf.method_10810());
        int enchantmentDestinationLevel = packetByteBuf.readInt();
        int requiredExperience = packetByteBuf.readInt();
        class_1792 requiredItem = (class_1792)class_2378.field_11142.method_10223(packetByteBuf.method_10810());
        int requiredItemCount = packetByteBuf.readInt();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, enchantment, enchantmentDestinationLevel, requiredExperience, requiredItem, requiredItemCount);
    }

    public static interface RecipeFactory<EnchantmentUpgradeRecipe> {
        public EnchantmentUpgradeRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_1887 var5, int var6, int var7, class_1792 var8, int var9);
    }
}

