/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.MultiblockCrafter;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldCondition;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.List;
import java.util.Optional;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineRecipe
extends GatedSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("build_fusion_shrine");
    protected final List<IngredientStack> craftingInputs;
    protected final class_3611 fluidInput;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean noBenefitsFromYieldUpgrades;
    protected final List<FusionShrineRecipeWorldCondition> worldConditions;
    @NotNull
    protected final FusionShrineRecipeWorldEffect startWorldEffect;
    @NotNull
    protected final List<FusionShrineRecipeWorldEffect> duringWorldEffects;
    @NotNull
    protected final FusionShrineRecipeWorldEffect finishWorldEffect;
    @Nullable
    protected final class_2561 description;

    public FusionShrineRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<IngredientStack> craftingInputs, class_3611 fluidInput, class_1799 output, float experience, int craftingTime, boolean noBenefitsFromYieldUpgrades, List<FusionShrineRecipeWorldCondition> worldConditions, FusionShrineRecipeWorldEffect startWorldEffect, List<FusionShrineRecipeWorldEffect> duringWorldEffects, FusionShrineRecipeWorldEffect finishWorldEffect, class_2561 description) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.craftingInputs = craftingInputs;
        this.fluidInput = fluidInput;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.worldConditions = worldConditions;
        this.startWorldEffect = startWorldEffect;
        this.duringWorldEffects = duringWorldEffects;
        this.finishWorldEffect = finishWorldEffect;
        this.description = description;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return FusionShrineRecipe.matchIngredientStacksExclusively(inv, this.getIngredientStacks());
    }

    public class_1799 method_8116(class_1263 inv) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.FUSION_SHRINE_BASALT);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.FUSION_SHRINE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.FUSION_SHRINE;
    }

    @Deprecated
    public class_2371<class_1856> method_8117() {
        return IngredientStack.listIngredients(this.craftingInputs);
    }

    public List<IngredientStack> getIngredientStacks() {
        return this.craftingInputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean areConditionMetCurrently(class_1937 world) {
        for (FusionShrineRecipeWorldCondition worldCondition : this.worldConditions) {
            if (worldCondition.isMetCurrently(world)) continue;
            return false;
        }
        return true;
    }

    public class_3611 getFluidInput() {
        return this.fluidInput;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public FusionShrineRecipeWorldEffect getWorldEffectForTick(int tick, int totalTicks) {
        if (tick == 1) {
            return this.startWorldEffect;
        }
        if (tick == totalTicks) {
            return this.finishWorldEffect;
        }
        if (this.duringWorldEffects.size() == 0) {
            return null;
        }
        if (this.duringWorldEffects.size() == 1) {
            return this.duringWorldEffects.get(0);
        }
        float parts = (float)totalTicks / (float)this.duringWorldEffects.size();
        int index = (int)((float)tick / parts);
        FusionShrineRecipeWorldEffect effect = this.duringWorldEffects.get(index);
        if (effect.isOneTimeEffect(effect) && index != (int)parts) {
            return null;
        }
        return effect;
    }

    public Optional<class_2561> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    public boolean areYieldUpgradesDisabled() {
        return this.noBenefitsFromYieldUpgrades;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "fusion_shrine";
    }

    public void craft(class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        int maxAmount = 1;
        if (!this.method_8110().method_7960()) {
            maxAmount = this.method_8110().method_7914();
            block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    int ingredientStackAmount = ingredientStack.getCount();
                    maxAmount = Math.min(maxAmount, currentStack.method_7947() / ingredientStackAmount);
                    continue block0;
                }
            }
            double efficiencyModifier = fusionShrineBlockEntity.getUpgrades().get((Object)Upgradeable.UpgradeType.EFFICIENCY).floatValue();
            if (maxAmount > 0) {
                block2: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                    for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                        class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                        if (!ingredientStack.test(currentStack)) continue;
                        int reducedAmount = maxAmount * ingredientStack.getCount();
                        int reducedAmountAfterMod = Support.getIntFromDecimalWithChance((double)reducedAmount / efficiencyModifier, world.field_9229);
                        if (currentStack.method_7947() - reducedAmountAfterMod < 1) {
                            fusionShrineBlockEntity.method_5447(i, class_1799.field_8037);
                            continue block2;
                        }
                        currentStack.method_7934(reducedAmountAfterMod);
                        continue block2;
                    }
                }
            }
        } else {
            block4: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgrades().get((Object)Upgradeable.UpgradeType.EFFICIENCY).floatValue();
                for (int i = 0; i < fusionShrineBlockEntity.method_5439(); ++i) {
                    class_1799 currentStack = fusionShrineBlockEntity.method_5438(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    int reducedAmountAfterMod = Support.getIntFromDecimalWithChance((double)ingredientStack.getCount() / efficiencyModifier, world.field_9229);
                    currentStack.method_7934(reducedAmountAfterMod);
                    continue block4;
                }
            }
        }
        this.spawnCraftingResultAndXP(world, fusionShrineBlockEntity, this.method_8110().method_7972(), maxAmount, this.noBenefitsFromYieldUpgrades, this.experience);
    }

    protected void spawnCraftingResultAndXP(@NotNull class_1937 world, @NotNull FusionShrineBlockEntity blockEntity, @NotNull class_1799 stack, int recipeCount, boolean yieldUpgradesDisabled, float experience) {
        int resultAmountBeforeMod = recipeCount * stack.method_7947();
        double yieldModifier = yieldUpgradesDisabled ? 1.0 : (double)blockEntity.getUpgradeValue(Upgradeable.UpgradeType.YIELD);
        int resultAmountAfterMod = Support.getIntFromDecimalWithChance((double)resultAmountBeforeMod * yieldModifier, world.field_9229);
        int intExperience = Support.getIntFromDecimalWithChance((float)recipeCount * experience, world.field_9229);
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, blockEntity.method_11016().method_10086(2), stack, resultAmountAfterMod, MultiblockCrafter.RECIPE_STACK_VELOCITY);
        if (experience > 0.0f) {
            MultiblockCrafter.spawnExperience(world, blockEntity.method_11016(), intExperience);
        }
        blockEntity.grantPlayerFusionCraftingAdvancement(this, intExperience);
    }
}

