/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.fusion_shrine;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldCondition;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipeWorldEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.RecipeParser;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class FusionShrineRecipeSerializer
implements GatedRecipeSerializer<FusionShrineRecipe> {
    public final RecipeFactory<FusionShrineRecipe> recipeFactory;

    public FusionShrineRecipeSerializer(RecipeFactory<FusionShrineRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public FusionShrineRecipe read(class_2960 identifier, JsonObject jsonObject) {
        class_2960 fluidIdentifier;
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArray = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        List craftingInputs = RecipeParser.ingredientStacksFromJson((JsonArray)ingredientArray, (int)ingredientArray.size());
        class_3611 fluid = class_3612.field_15906;
        if (class_3518.method_15289((JsonObject)jsonObject, (String)"fluid") && (fluid = (class_3611)class_2378.field_11154.method_10223(fluidIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"fluid")))).method_15785().method_15769()) {
            SpectrumCommon.logError("Fusion Shrine Recipe " + identifier + " specifies fluid " + fluidIdentifier + " that does not exist! This recipe will not be craftable.");
        }
        class_1799 output = class_3518.method_34923((JsonObject)jsonObject, (String)"result") ? RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result")) : class_1799.field_8037;
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_upgrades")) {
            noBenefitsFromYieldUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        }
        ArrayList<FusionShrineRecipeWorldCondition> worldConditions = new ArrayList<FusionShrineRecipeWorldCondition>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"world_conditions")) {
            JsonArray conditionsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"world_conditions");
            for (int i = 0; i < conditionsArray.size(); ++i) {
                String conditionString = conditionsArray.get(i).getAsString().toUpperCase(Locale.ROOT);
                worldConditions.add(FusionShrineRecipeWorldCondition.valueOf(conditionString));
            }
        }
        FusionShrineRecipeWorldEffect startWorldEffect = class_3518.method_15289((JsonObject)jsonObject, (String)"start_crafting_effect") ? FusionShrineRecipeWorldEffect.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"start_crafting_effect").toUpperCase(Locale.ROOT)) : FusionShrineRecipeWorldEffect.NOTHING;
        ArrayList<FusionShrineRecipeWorldEffect> duringWorldEffects = new ArrayList<FusionShrineRecipeWorldEffect>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"during_crafting_effects")) {
            JsonArray worldEffectsArray = class_3518.method_15261((JsonObject)jsonObject, (String)"during_crafting_effects");
            for (int i = 0; i < worldEffectsArray.size(); ++i) {
                String effectString = worldEffectsArray.get(i).getAsString().toUpperCase(Locale.ROOT);
                duringWorldEffects.add(FusionShrineRecipeWorldEffect.valueOf(effectString));
            }
        }
        FusionShrineRecipeWorldEffect finishWorldEffect = class_3518.method_15289((JsonObject)jsonObject, (String)"finish_crafting_effect") ? FusionShrineRecipeWorldEffect.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"finish_crafting_effect").toUpperCase(Locale.ROOT)) : FusionShrineRecipeWorldEffect.NOTHING;
        class_5250 description = class_3518.method_15289((JsonObject)jsonObject, (String)"description") ? class_2561.method_43471((String)class_3518.method_15265((JsonObject)jsonObject, (String)"description")) : null;
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, craftingInputs, fluid, output, experience, craftingTime, noBenefitsFromYieldUpgrades, worldConditions, startWorldEffect, duringWorldEffects, finishWorldEffect, (class_2561)description);
    }

    public void write(class_2540 packetByteBuf, FusionShrineRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeShort(recipe.craftingInputs.size());
        for (IngredientStack ingredientStack : recipe.craftingInputs) {
            ingredientStack.write(packetByteBuf);
        }
        packetByteBuf.method_10812(class_2378.field_11154.method_10221((Object)recipe.fluidInput));
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeBoolean(recipe.noBenefitsFromYieldUpgrades);
        packetByteBuf.writeShort(recipe.worldConditions.size());
        for (FusionShrineRecipeWorldCondition worldCondition : recipe.worldConditions) {
            packetByteBuf.writeInt(worldCondition.ordinal());
        }
        packetByteBuf.writeInt(recipe.startWorldEffect.ordinal());
        packetByteBuf.writeInt(recipe.duringWorldEffects.size());
        for (FusionShrineRecipeWorldEffect effect : recipe.duringWorldEffects) {
            packetByteBuf.writeInt(effect.ordinal());
        }
        packetByteBuf.writeInt(recipe.finishWorldEffect.ordinal());
        if (recipe.getDescription().isEmpty()) {
            packetByteBuf.method_10805((class_2561)class_2561.method_43470((String)""));
        } else {
            packetByteBuf.method_10805(recipe.getDescription().get());
        }
    }

    public FusionShrineRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        short craftingInputCount = packetByteBuf.readShort();
        List ingredients = IngredientStack.decodeByteBuf((class_2540)packetByteBuf, (int)craftingInputCount);
        class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(packetByteBuf.method_10810());
        class_1799 output = packetByteBuf.method_10819();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean noBenefitsFromYieldUpgrades = packetByteBuf.readBoolean();
        short worldConditionCount = packetByteBuf.readShort();
        ArrayList<FusionShrineRecipeWorldCondition> worldConditions = new ArrayList<FusionShrineRecipeWorldCondition>();
        for (short i = 0; i < worldConditionCount; i = (short)(i + 1)) {
            worldConditions.add(FusionShrineRecipeWorldCondition.values()[packetByteBuf.readInt()]);
        }
        FusionShrineRecipeWorldEffect startWorldEffect = FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()];
        int duringWorldEventCount = packetByteBuf.readInt();
        ArrayList<FusionShrineRecipeWorldEffect> duringWorldEffects = new ArrayList<FusionShrineRecipeWorldEffect>();
        for (int i = 0; i < duringWorldEventCount; ++i) {
            duringWorldEffects.add(FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()]);
        }
        FusionShrineRecipeWorldEffect finishWorldEffect = FusionShrineRecipeWorldEffect.values()[packetByteBuf.readInt()];
        class_2561 description = packetByteBuf.method_10808();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, fluid, output, experience, craftingTime, noBenefitsFromYieldUpgrades, worldConditions, startWorldEffect, duringWorldEffects, finishWorldEffect, description);
    }

    public static interface RecipeFactory<FusionShrineRecipe> {
        public FusionShrineRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, List<IngredientStack> var5, class_3611 var6, class_1799 var7, float var8, int var9, boolean var10, List<FusionShrineRecipeWorldCondition> var11, FusionShrineRecipeWorldEffect var12, List<FusionShrineRecipeWorldEffect> var13, FusionShrineRecipeWorldEffect var14, class_2561 var15);
    }
}

