/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockItem;
import de.dafuqs.spectrum.blocks.pedestal.PedestalVariant;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.GemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.HashMap;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import oshi.util.tuples.Triplet;

public class PedestalCraftingRecipe
extends GatedSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("place_pedestal");
    protected final int width;
    protected final int height;
    protected final PedestalRecipeTier tier;
    protected final class_2371<IngredientStack> craftingInputs;
    protected final HashMap<BuiltinGemstoneColor, Integer> gemstonePowderInputs;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean skipRecipeRemainders;
    protected final boolean noBenefitsFromYieldUpgrades;

    public PedestalCraftingRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, PedestalRecipeTier tier, int width, int height, class_2371<IngredientStack> craftingInputs, HashMap<BuiltinGemstoneColor, Integer> gemstonePowderInputs, class_1799 output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.tier = tier;
        this.width = width;
        this.height = height;
        this.craftingInputs = craftingInputs;
        this.gemstonePowderInputs = gemstonePowderInputs;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.skipRecipeRemainders = skipRecipeRemainders;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.registerInToastManager(this.method_17716(), this);
    }

    public static PedestalVariant getUpgradedPedestalVariantForOutput(class_1799 outputItemStack) {
        if (outputItemStack.method_7909() instanceof PedestalBlockItem) {
            return ((PedestalBlockItem)outputItemStack.method_7909()).getVariant();
        }
        return null;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        if (!this.matchesGrid(inv)) {
            return false;
        }
        int topazPowderAmount = this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.CYAN, 0);
        int amethystPowderAmount = this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.MAGENTA, 0);
        int citrinePowderAmount = this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.YELLOW, 0);
        int onyxPowderAmount = this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.BLACK, 0);
        int moonstonePowderAmount = this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.WHITE, 0);
        return !(topazPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(9), SpectrumItems.TOPAZ_POWDER, topazPowderAmount) || amethystPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(10), SpectrumItems.AMETHYST_POWDER, amethystPowderAmount) || citrinePowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(11), SpectrumItems.CITRINE_POWDER, citrinePowderAmount) || onyxPowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(12), SpectrumItems.ONYX_POWDER, onyxPowderAmount) || moonstonePowderAmount != 0 && !this.isStackAtLeast(inv.method_5438(13), SpectrumItems.MOONSTONE_POWDER, moonstonePowderAmount));
    }

    public boolean matchesGrid(class_1263 inv) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matchesPattern(inv, i, j, true)) {
                    return true;
                }
                if (!this.matchesPattern(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesPattern(class_1263 inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                IngredientStack ingredient = IngredientStack.EMPTY;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = flipped ? (IngredientStack)this.craftingInputs.get(this.width - k - 1 + l * this.width) : (IngredientStack)this.craftingInputs.get(k + l * this.width);
                }
                if (ingredient.test(inv.method_5438(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isStackAtLeast(class_1799 sourceItemStack, class_1792 item, int amount) {
        return sourceItemStack.method_7909().equals(item) && sourceItemStack.method_7947() >= amount;
    }

    @Deprecated
    public class_2371<class_1856> method_8117() {
        class_2371 defList = class_2371.method_10211();
        this.craftingInputs.stream().map(IngredientStack::getIngredient).forEach(arg_0 -> defList.add(arg_0));
        return defList;
    }

    public class_2371<IngredientStack> getIngredientStacks() {
        return this.craftingInputs;
    }

    public Triplet<Integer, Integer, Boolean> getRecipeOrientation(class_1263 inv) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matchesPattern(inv, i, j, true)) {
                    return new Triplet((Object)i, (Object)j, (Object)true);
                }
                if (!this.matchesPattern(inv, i, j, false)) continue;
                return new Triplet((Object)i, (Object)j, (Object)false);
            }
        }
        return null;
    }

    public class_1799 method_8116(class_1263 inv) {
        if (inv instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)inv;
            Triplet<Integer, Integer, Boolean> orientation = this.getRecipeOrientation(inv);
            if (orientation == null) {
                return class_1799.field_8037;
            }
            this.decrementIngredientStacks(pedestal, orientation);
            class_1799 recipeOutput = this.output.method_7972();
            class_1657 player = pedestal.getOwnerIfOnline();
            if (player != null) {
                recipeOutput.method_7982(pedestal.method_10997(), player, recipeOutput.method_7947());
            }
            return recipeOutput;
        }
        return class_1799.field_8037;
    }

    protected void decrementIngredientStacks(PedestalBlockEntity pedestal, Triplet<Integer, Integer, Boolean> orientation) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                class_1799 remainderStack;
                class_1792 recipeReminderItem;
                class_1799 invStack;
                int ingredientStackId = (Boolean)orientation.getC() != false ? this.width - 1 - x + this.width * y : x + this.width * y;
                int invStackId = x + (Integer)orientation.getA() + 3 * (y + (Integer)orientation.getB());
                IngredientStack ingredientStackAtPos = (IngredientStack)this.craftingInputs.get(ingredientStackId);
                if (!ingredientStackAtPos.test(invStack = pedestal.method_5438(invStackId))) {
                    SpectrumCommon.logError("Looks like DaFuqs fucked up Spectrums Pedestal recipe matching. Go open up a report with the recipe that was crafted and an image of the pedestals contents, please! :)");
                }
                if (invStack.method_7960()) continue;
                class_1792 class_17922 = recipeReminderItem = this.skipRecipeRemainders() ? null : invStack.method_7909().method_7858();
                if (recipeReminderItem == null) {
                    invStack.method_7934(ingredientStackAtPos.getCount());
                    continue;
                }
                if (pedestal.method_5438(invStackId).method_7947() == ingredientStackAtPos.getCount()) {
                    remainderStack = recipeReminderItem.method_7854();
                    remainderStack.method_7939(ingredientStackAtPos.getCount());
                    pedestal.method_5447(invStackId, remainderStack);
                    continue;
                }
                pedestal.method_5438(invStackId).method_7934(ingredientStackAtPos.getCount());
                remainderStack = recipeReminderItem.method_7854();
                class_1542 itemEntity = new class_1542(pedestal.method_10997(), (double)pedestal.method_11016().method_10263() + 0.5, (double)(pedestal.method_11016().method_10264() + 1), (double)pedestal.method_11016().method_10260() + 0.5, remainderStack);
                itemEntity.method_5762(0.0, 0.05, 0.0);
                pedestal.method_10997().method_8649((class_1297)itemEntity);
            }
        }
        for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
            double efficiencyModifier = pedestal.getUpgradeValue(Upgradeable.UpgradeType.EFFICIENCY);
            int gemstonePowderAmount = this.getGemstonePowderAmount(gemstoneColor);
            int gemstonePowderAmountAfterMod = Support.getIntFromDecimalWithChance((double)gemstonePowderAmount / efficiencyModifier, pedestal.method_10997().field_9229);
            pedestal.method_5438(PedestalBlockEntity.getSlotForGemstonePowder(gemstoneColor)).method_7934(gemstonePowderAmountAfterMod);
        }
    }

    public PedestalRecipeTier getTier() {
        return this.tier;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.PEDESTAL_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.PEDESTAL;
    }

    public int getGemstonePowderAmount(GemstoneColor gemstoneColor) {
        return this.gemstonePowderInputs.getOrDefault(gemstoneColor, 0);
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public HashMap<BuiltinGemstoneColor, Integer> getGemstonePowderInputs() {
        return this.gemstonePowderInputs;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_3414 getSoundEvent(class_5819 random) {
        int i;
        ArrayList<class_3414> choices = new ArrayList<class_3414>();
        for (i = 0; i < this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.MAGENTA, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_AMETHYST);
        }
        for (i = 0; i < this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.YELLOW, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_CITRINE);
        }
        for (i = 0; i < this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.CYAN, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_TOPAZ);
        }
        for (i = 0; i < this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.BLACK, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_ONYX);
        }
        for (i = 0; i < this.gemstonePowderInputs.getOrDefault(BuiltinGemstoneColor.WHITE, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_MOONSTONE);
        }
        if (choices.size() == 0) {
            return SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC;
        }
        return (class_3414)choices.get(random.method_43048(choices.size()));
    }

    public boolean canCraft(PedestalBlockEntity pedestalBlockEntity) {
        class_1657 playerEntity = pedestalBlockEntity.getOwnerIfOnline();
        if (playerEntity == null) {
            return false;
        }
        return this.canPlayerCraft(playerEntity) && (PedestalCraftingRecipe.getUpgradedPedestalVariantForOutput(this.output) != null || pedestalBlockEntity.getHighestAvailableRecipeTierWithStructure().ordinal() >= this.tier.ordinal());
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public boolean canPlayerCraft(class_1657 playerEntity) {
        return PedestalRecipeTier.hasUnlockedRequiredTier(playerEntity, this.tier) && AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.requiredAdvancementIdentifier);
    }

    @Override
    public String getRecipeTypeShortID() {
        return SpectrumRecipeTypes.PEDESTAL_RECIPE_ID;
    }

    public boolean areYieldUpgradesDisabled() {
        return this.noBenefitsFromYieldUpgrades;
    }

    public boolean skipRecipeRemainders() {
        return this.skipRecipeRemainders;
    }
}

