/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.enums.BuiltinGemstoneColor;
import de.dafuqs.spectrum.enums.PedestalRecipeTier;
import de.dafuqs.spectrum.mixin.accessors.ShapedRecipeAccessor;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.pedestal.PedestalCraftingRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.RecipeParser;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class PedestalCraftingRecipeSerializer
implements GatedRecipeSerializer<PedestalCraftingRecipe> {
    public final RecipeFactory<PedestalCraftingRecipe> recipeFactory;

    public PedestalCraftingRecipeSerializer(RecipeFactory<PedestalCraftingRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public PedestalCraftingRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        Map<String, IngredientStack> map = PedestalCraftingRecipeSerializer.readIngredientStackSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
        String[] strings = ShapedRecipeAccessor.invokeRemovePadding(ShapedRecipeAccessor.invokeGetPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
        int width = strings[0].length();
        int height = strings.length;
        class_2371<IngredientStack> craftingInputs = PedestalCraftingRecipeSerializer.createIngredientStackPatternMatrix(strings, map, width, height);
        class_1799 output = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        PedestalRecipeTier tier = PedestalRecipeTier.valueOf(class_3518.method_15253((JsonObject)jsonObject, (String)"tier", (String)"basic").toUpperCase(Locale.ROOT));
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldUpgrades = false;
        if (class_3518.method_15278((JsonObject)jsonObject, (String)"disable_yield_upgrades")) {
            noBenefitsFromYieldUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        }
        HashMap<BuiltinGemstoneColor, Integer> gemInputs = new HashMap<BuiltinGemstoneColor, Integer>();
        int amount = class_3518.method_15282((JsonObject)jsonObject, (String)"cyan", (int)0);
        if (amount > 0) {
            gemInputs.put(BuiltinGemstoneColor.CYAN, amount);
        }
        if ((amount = class_3518.method_15282((JsonObject)jsonObject, (String)"magenta", (int)0)) > 0) {
            gemInputs.put(BuiltinGemstoneColor.MAGENTA, amount);
        }
        if ((amount = class_3518.method_15282((JsonObject)jsonObject, (String)"yellow", (int)0)) > 0) {
            gemInputs.put(BuiltinGemstoneColor.YELLOW, amount);
        }
        if ((amount = class_3518.method_15282((JsonObject)jsonObject, (String)"black", (int)0)) > 0) {
            gemInputs.put(BuiltinGemstoneColor.BLACK, amount);
        }
        if ((amount = class_3518.method_15282((JsonObject)jsonObject, (String)"white", (int)0)) > 0) {
            gemInputs.put(BuiltinGemstoneColor.WHITE, amount);
        }
        boolean skipRecipeRemainders = false;
        if (class_3518.method_15254((JsonObject)jsonObject, (String)"skip_recipe_remainders")) {
            skipRecipeRemainders = class_3518.method_15258((JsonObject)jsonObject, (String)"skip_recipe_remainders", (boolean)false);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, tier, width, height, craftingInputs, gemInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
    }

    static class_2371<IngredientStack> createIngredientStackPatternMatrix(String[] pattern, Map<String, IngredientStack> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)IngredientStack.EMPTY);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                IngredientStack ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    static Map<String, IngredientStack> readIngredientStackSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), RecipeParser.ingredientStackFromJson((JsonObject)((JsonObject)entry.getValue())));
        }
        map.put(" ", IngredientStack.EMPTY);
        return map;
    }

    public void write(class_2540 packetByteBuf, PedestalCraftingRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeInt(recipe.width);
        packetByteBuf.writeInt(recipe.height);
        for (IngredientStack ingredient : recipe.craftingInputs) {
            ingredient.write(packetByteBuf);
        }
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeInt(recipe.tier.ordinal());
        packetByteBuf.writeInt(recipe.getGemstonePowderAmount(BuiltinGemstoneColor.CYAN));
        packetByteBuf.writeInt(recipe.getGemstonePowderAmount(BuiltinGemstoneColor.MAGENTA));
        packetByteBuf.writeInt(recipe.getGemstonePowderAmount(BuiltinGemstoneColor.YELLOW));
        packetByteBuf.writeInt(recipe.getGemstonePowderAmount(BuiltinGemstoneColor.BLACK));
        packetByteBuf.writeInt(recipe.getGemstonePowderAmount(BuiltinGemstoneColor.WHITE));
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeBoolean(recipe.skipRecipeRemainders);
        packetByteBuf.writeBoolean(recipe.noBenefitsFromYieldUpgrades);
    }

    public PedestalCraftingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        int width = packetByteBuf.readInt();
        int height = packetByteBuf.readInt();
        class_2371 craftingInputs = class_2371.method_10213((int)(width * height), (Object)IngredientStack.EMPTY);
        for (int k = 0; k < craftingInputs.size(); ++k) {
            try {
                craftingInputs.set(k, (Object)IngredientStack.fromByteBuf((class_2540)packetByteBuf));
                continue;
            }
            catch (Exception e) {
                SpectrumCommon.logError("!");
            }
        }
        class_1799 output = packetByteBuf.method_10819();
        PedestalRecipeTier tier = PedestalRecipeTier.values()[packetByteBuf.readInt()];
        int cyan = packetByteBuf.readInt();
        int magenta = packetByteBuf.readInt();
        int yellow = packetByteBuf.readInt();
        int black = packetByteBuf.readInt();
        int white = packetByteBuf.readInt();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean skipRecipeRemainders = packetByteBuf.readBoolean();
        boolean noBenefitsFromYieldUpgrades = packetByteBuf.readBoolean();
        HashMap<BuiltinGemstoneColor, Integer> gemInputs = new HashMap<BuiltinGemstoneColor, Integer>();
        if (cyan > 0) {
            gemInputs.put(BuiltinGemstoneColor.CYAN, cyan);
        }
        if (magenta > 0) {
            gemInputs.put(BuiltinGemstoneColor.MAGENTA, magenta);
        }
        if (yellow > 0) {
            gemInputs.put(BuiltinGemstoneColor.YELLOW, yellow);
        }
        if (black > 0) {
            gemInputs.put(BuiltinGemstoneColor.BLACK, black);
        }
        if (white > 0) {
            gemInputs.put(BuiltinGemstoneColor.WHITE, white);
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, tier, width, height, (class_2371<IngredientStack>)craftingInputs, gemInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
    }

    public static interface RecipeFactory<PedestalCraftingRecipe> {
        public PedestalCraftingRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, PedestalRecipeTier var5, int var6, int var7, class_2371<IngredientStack> var8, HashMap<BuiltinGemstoneColor, Integer> var9, class_1799 var10, float var11, int var12, boolean var13, boolean var14);
    }
}

