/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.interfaces.PotionFillable;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.recipe.potion_workshop.StatusEffectHelper;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBrewingRecipe
extends PotionWorkshopRecipe {
    public static final List<class_1291> availablePositiveEffects = new ArrayList<class_1291>();
    public static final List<Integer> availablePositiveEffectDurations = new ArrayList<Integer>();
    public static final List<Float> availablePositiveEffectPotencyMods = new ArrayList<Float>();
    public static final List<class_1291> availableNegativeEffects = new ArrayList<class_1291>();
    public static final List<Integer> availableNegativeEffectDurations = new ArrayList<Integer>();
    public static final List<Float> availableNegativeEffectPotencyMods = new ArrayList<Float>();
    protected static final List<class_3545<Float, Float>> SPLIT_EFFECT_POTENCY_AND_DURATION = new ArrayList<class_3545<Float, Float>>(){
        {
            this.add(new class_3545((Object)Float.valueOf(2.0f), (Object)Float.valueOf(0.15f)));
            this.add(new class_3545((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.5f)));
            this.add(new class_3545((Object)Float.valueOf(0.25f), (Object)Float.valueOf(1.0f)));
        }
    };
    protected final class_1291 statusEffect;
    protected final int baseDurationTicks;
    protected final float potencyModifier;
    protected final boolean applicableToPotions;
    protected final boolean applicableToTippedArrows;
    protected final boolean applicableToPotionFillabes;
    protected class_1799 cachedOutput;

    public PotionWorkshopBrewingRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, int craftingTime, class_1856 ingredient1, class_1856 ingredient2, class_1856 ingredient3, class_1291 statusEffect, int baseDurationTicks, float potencyModifier, int color, boolean applicableToPotions, boolean applicableToTippedArrows, boolean applicableToPotionFillabes) {
        super(id, group, secret, requiredAdvancementIdentifier, craftingTime, color, ingredient1, ingredient2, ingredient3);
        this.statusEffect = statusEffect;
        this.baseDurationTicks = baseDurationTicks;
        this.potencyModifier = potencyModifier;
        this.applicableToPotions = applicableToPotions;
        this.applicableToTippedArrows = applicableToTippedArrows;
        this.applicableToPotionFillabes = applicableToPotionFillabes;
        if (statusEffect.method_5573()) {
            if (!availablePositiveEffects.contains(statusEffect)) {
                availablePositiveEffects.add(statusEffect);
                availablePositiveEffectDurations.add(baseDurationTicks);
                availablePositiveEffectPotencyMods.add(Float.valueOf(potencyModifier));
            }
        } else if (!availableNegativeEffects.contains(statusEffect)) {
            availableNegativeEffects.add(statusEffect);
            availableNegativeEffectDurations.add(baseDurationTicks);
            availableNegativeEffectPotencyMods.add(Float.valueOf(potencyModifier));
        }
        this.registerInToastManager(this.method_17716(), this);
    }

    @Override
    public boolean isValidBaseIngredient(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8469) && this.applicableToPotions || itemStack.method_31574(class_1802.field_8107) && this.applicableToTippedArrows || itemStack.method_7909() instanceof PotionFillable;
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_BREWING_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_BREWING;
    }

    @Override
    public boolean usesReagents() {
        return true;
    }

    public boolean isApplicableToPotions() {
        return this.applicableToPotions;
    }

    public boolean isApplicableToTippedArrows() {
        return this.applicableToTippedArrows;
    }

    public boolean isApplicableToPotionFillabes() {
        return this.applicableToPotionFillabes;
    }

    @Override
    public int getMinOutputCount(class_1799 baseItemStack) {
        return baseItemStack.method_31574(class_1802.field_8469) ? 3 : 1;
    }

    @Override
    public int getColor() {
        if (this.color == -1) {
            return this.statusEffect.method_5556();
        }
        return this.color;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{SpectrumItems.MERMAIDS_GEM.method_7854()}));
        defaultedList.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{class_1802.field_8469.method_7854()}));
        defaultedList.add((Object)this.ingredient1);
        defaultedList.add((Object)this.ingredient2);
        defaultedList.add((Object)this.ingredient3);
        return defaultedList;
    }

    public class_1799 method_8110() {
        if (this.cachedOutput == null) {
            this.cachedOutput = this.brewRandomPotion(new PotionMod(), null, class_5819.method_43047());
        }
        return this.cachedOutput;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return null;
    }

    public class_1799 brewRandomPotion(PotionMod potionMod, class_1291 lastBrewedStatusEffect, class_5819 random) {
        List<class_1293> effects = new ArrayList<class_1293>();
        this.addMainEffect(potionMod, random, effects);
        this.addRandomAdditionalEffects(potionMod, random, effects);
        if (lastBrewedStatusEffect != null && (potionMod.chanceToAddLastEffect >= 1.0f || random.method_43057() < potionMod.chanceToAddLastEffect)) {
            this.applyLastBrewedStatusEffect(potionMod, lastBrewedStatusEffect, random, effects);
        }
        if (potionMod.potentDecreasingEffect) {
            effects = this.applyPotentDecreasingEffect(effects, random);
        }
        class_1799 itemStack = potionMod.makeSplashing ? (potionMod.makeLingering ? new class_1799((class_1935)class_1802.field_8150) : new class_1799((class_1935)class_1802.field_8436)) : new class_1799((class_1935)class_1802.field_8574);
        if (effects.size() == 0) {
            class_1844.method_8061((class_1799)itemStack, (class_1842)class_1847.field_8985);
        } else {
            class_1844.method_8061((class_1799)itemStack, (class_1842)SpectrumPotions.PIGMENT_POTION);
            class_1844.method_8056((class_1799)itemStack, effects);
        }
        if (potionMod.fastDrinkable) {
            class_2487 compound = itemStack.method_7948();
            compound.method_10556("SpectrumFastDrinkable", true);
            itemStack.method_7980(compound);
        }
        this.setColor(itemStack, potionMod, effects);
        return itemStack;
    }

    public class_1799 getTippedArrows(PotionMod potionMod, class_1291 lastBrewedStatusEffect, int amount, class_5819 random) {
        List<class_1293> effects = new ArrayList<class_1293>();
        this.addMainEffect(potionMod, random, effects);
        this.addRandomAdditionalEffects(potionMod, random, effects);
        if (lastBrewedStatusEffect != null && (potionMod.chanceToAddLastEffect >= 1.0f || random.method_43057() < potionMod.chanceToAddLastEffect)) {
            this.applyLastBrewedStatusEffect(potionMod, lastBrewedStatusEffect, random, effects);
        }
        if (potionMod.potentDecreasingEffect) {
            effects = this.applyPotentDecreasingEffect(effects, random);
        }
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8087, amount);
        if (effects.size() == 0) {
            class_1844.method_8061((class_1799)itemStack, (class_1842)class_1847.field_8985);
        } else {
            class_1844.method_8061((class_1799)itemStack, (class_1842)SpectrumPotions.PIGMENT_POTION);
            class_1844.method_8056((class_1799)itemStack, effects);
        }
        itemStack.method_7977((class_2561)class_2561.method_43471((String)"item.spectrum.tipped_arrow"));
        this.setColor(itemStack, potionMod, effects);
        return itemStack;
    }

    public void fillPotionFillable(class_1799 potionFillableStack, PotionMod potionMod, class_1291 lastBrewedStatusEffect, class_5819 random) {
        class_1792 class_17922 = potionFillableStack.method_7909();
        if (class_17922 instanceof PotionFillable) {
            PotionFillable potionFillable = (PotionFillable)class_17922;
            List<class_1293> newEffects = new ArrayList<class_1293>();
            this.addMainEffect(potionMod, random, newEffects);
            this.addRandomAdditionalEffects(potionMod, random, newEffects);
            if (lastBrewedStatusEffect != null && (potionMod.chanceToAddLastEffect >= 1.0f || random.method_43057() < potionMod.chanceToAddLastEffect)) {
                this.applyLastBrewedStatusEffect(potionMod, lastBrewedStatusEffect, random, newEffects);
            }
            if (potionMod.potentDecreasingEffect) {
                newEffects = this.applyPotentDecreasingEffect(newEffects, random);
            }
            potionFillable.addEffects(potionFillableStack, newEffects);
            this.setColor(potionFillableStack, potionMod, newEffects);
        }
    }

    private void addMainEffect(PotionMod potionMod, class_5819 random, List<class_1293> effects) {
        if (potionMod.makeEffectsPositive) {
            int index;
            class_1291 positiveEffect = StatusEffectHelper.getPositiveVariant(this.statusEffect);
            if (positiveEffect != null && (index = availablePositiveEffects.indexOf(positiveEffect)) != -1) {
                int baseDuration = availablePositiveEffectDurations.get(index);
                float basePotency = availablePositiveEffectPotencyMods.get(index).floatValue();
                effects.add(this.getStatusEffectInstance(positiveEffect, baseDuration, basePotency, potionMod, random));
            }
        } else {
            class_1293 statusEffectInstance = this.getStatusEffectInstance(this.statusEffect, this.baseDurationTicks, this.potencyModifier, potionMod, random);
            if (statusEffectInstance != null) {
                effects.add(statusEffectInstance);
            }
        }
    }

    private void addRandomAdditionalEffects(PotionMod potionMod, class_5819 random, List<class_1293> effects) {
        class_1293 statusEffectInstance;
        int r;
        class_1291 selectedStatusEffect;
        int tries;
        int i;
        if (availablePositiveEffects.size() > 0) {
            int additionalPositiveEffects = Support.getIntFromDecimalWithChance(potionMod.additionalRandomPositiveEffectCount, random);
            for (i = 0; i < additionalPositiveEffects; ++i) {
                tries = 0;
                do {
                    if (!this.isEffectInList(effects, selectedStatusEffect = availablePositiveEffects.get(r = random.method_43048(availablePositiveEffects.size())))) continue;
                    selectedStatusEffect = null;
                    ++tries;
                } while (selectedStatusEffect == null && tries < 5);
                if (selectedStatusEffect == null || (statusEffectInstance = this.getStatusEffectInstance(selectedStatusEffect, availablePositiveEffectDurations.get(r), availablePositiveEffectPotencyMods.get(r).floatValue(), potionMod, random)) == null) continue;
                effects.add(statusEffectInstance);
            }
        }
        if (availableNegativeEffects.size() > 0) {
            int additionalNegativeEffects = Support.getIntFromDecimalWithChance(potionMod.additionalRandomNegativeEffectCount, random);
            for (i = 0; i < additionalNegativeEffects; ++i) {
                tries = 0;
                do {
                    class_1291 positiveEffect;
                    r = random.method_43048(availableNegativeEffects.size());
                    selectedStatusEffect = availableNegativeEffects.get(r);
                    if (potionMod.makeEffectsPositive && (positiveEffect = StatusEffectHelper.getPositiveVariant(selectedStatusEffect)) != null) {
                        selectedStatusEffect = positiveEffect;
                    }
                    if (!this.isEffectInList(effects, selectedStatusEffect)) continue;
                    selectedStatusEffect = null;
                    ++tries;
                } while (selectedStatusEffect == null && tries < 5);
                if (selectedStatusEffect == null || (statusEffectInstance = this.getStatusEffectInstance(selectedStatusEffect, availableNegativeEffectDurations.get(r), availableNegativeEffectPotencyMods.get(r).floatValue(), potionMod, random)) == null) continue;
                effects.add(statusEffectInstance);
            }
        }
    }

    private boolean isEffectInList(List<class_1293> effects, class_1291 selectedStatusEffect) {
        for (class_1293 existingInstance : effects) {
            if (existingInstance.method_5579() != selectedStatusEffect) continue;
            return true;
        }
        return false;
    }

    private void applyLastBrewedStatusEffect(PotionMod potionMod, class_1291 lastBrewedStatusEffect, class_5819 random, List<class_1293> effects) {
        class_1291 effect = lastBrewedStatusEffect;
        if (potionMod.makeEffectsPositive) {
            effect = StatusEffectHelper.getPositiveVariant(lastBrewedStatusEffect);
        }
        if (effect != null) {
            class_1293 statusEffectInstance;
            int baseDuration = 0;
            float basePotency = 0.0f;
            if (effect.method_5573()) {
                index = availablePositiveEffects.indexOf(effect);
                if (index != -1) {
                    baseDuration = availablePositiveEffectDurations.get(index);
                    basePotency = availablePositiveEffectPotencyMods.get(index).floatValue();
                }
            } else {
                index = availableNegativeEffects.indexOf(effect);
                if (index != -1) {
                    baseDuration = availableNegativeEffectDurations.get(index);
                    basePotency = availableNegativeEffectPotencyMods.get(index).floatValue();
                }
            }
            if (basePotency >= 0.0f && (statusEffectInstance = this.getStatusEffectInstance(effect, baseDuration, basePotency * potionMod.lastEffectPotencyModifier, potionMod, random)) != null) {
                effects.add(statusEffectInstance);
            }
        }
    }

    public void setColor(class_1799 itemStack, PotionMod potionMod, List<class_1293> effects) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (potionMod.unidentifiable) {
            nbtCompound.method_10569("CustomPotionColor", 0x2F2F2F);
            nbtCompound.method_10556("spectrum_unidentifiable", true);
            itemStack.method_7980(nbtCompound);
        } else if (effects.size() > 0) {
            nbtCompound.method_10569("CustomPotionColor", this.getColor());
        }
    }

    @Nullable
    public class_1293 getStatusEffectInstance(@NotNull class_1291 statusEffect, int baseDurationTicks, float potencyModifier, @NotNull PotionMod potionMod, class_5819 random) {
        int durationTicks = 1;
        if (!statusEffect.method_5561()) {
            durationTicks = (int)((float)baseDurationTicks * potionMod.multiplicativeDurationModifier + (float)potionMod.flatDurationBonusTicks);
        }
        float posNegBonus = potionMod.flatPotencyBonusNegativeEffects;
        if (statusEffect.method_5573()) {
            posNegBonus = potionMod.flatPotencyBonusPositiveEffects;
        }
        int potency = 0;
        if (potencyModifier > 0.0f) {
            potency = Support.getIntFromDecimalWithChance(potencyModifier * potionMod.multiplicativePotencyModifier + potionMod.flatPotencyBonus + posNegBonus, random) - 1;
        }
        if (potency < 0 && (double)potionMod.multiplicativePotencyModifier >= 1.0) {
            potency = 0;
        }
        if (potency >= 0 && (statusEffect.method_5561() || durationTicks > 0)) {
            return new class_1293(statusEffect, durationTicks, potency, !potionMod.noParticles, !potionMod.noParticles);
        }
        return null;
    }

    public List<class_1293> applyPotentDecreasingEffect(@NotNull List<class_1293> statusEffectInstances, class_5819 random) {
        ArrayList<class_1293> splitInstances = new ArrayList<class_1293>();
        for (class_1293 instance : statusEffectInstances) {
            for (class_3545<Float, Float> mods : SPLIT_EFFECT_POTENCY_AND_DURATION) {
                int newDuration = (int)((float)instance.method_5584() * ((Float)mods.method_15441()).floatValue());
                int newAmplifier = Support.getIntFromDecimalWithChance((float)instance.method_5578() * ((Float)mods.method_15442()).floatValue(), random);
                if (newAmplifier <= 0) continue;
                splitInstances.add(new class_1293(instance.method_5579(), newDuration, newAmplifier, instance.method_5591(), instance.method_5581()));
            }
        }
        return splitInstances;
    }

    public class_1291 getStatusEffect() {
        return this.statusEffect;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_brewing";
    }
}

