/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopBrewingRecipe;
import net.minecraft.class_1291;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class PotionWorkshopBrewingRecipeSerializer
implements GatedRecipeSerializer<PotionWorkshopBrewingRecipe> {
    public final RecipeFactory<PotionWorkshopBrewingRecipe> recipeFactory;

    public PotionWorkshopBrewingRecipeSerializer(RecipeFactory<PotionWorkshopBrewingRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public PotionWorkshopBrewingRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_1856 ingredient1 = class_1856.method_8102((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient1"));
        class_1856 ingredient2 = class_3518.method_34923((JsonObject)jsonObject, (String)"ingredient2") ? class_1856.method_8102((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient2")) : class_1856.field_9017;
        class_1856 ingredient3 = class_3518.method_34923((JsonObject)jsonObject, (String)"ingredient3") ? class_1856.method_8102((JsonElement)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient3")) : class_1856.field_9017;
        boolean applicableToPotions = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_potions", (boolean)true);
        boolean applicableToTippedArrows = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_tipped_arrows", (boolean)true);
        boolean applicableToPotionFillabes = class_3518.method_15258((JsonObject)jsonObject, (String)"applicable_to_potion_fillables", (boolean)true);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        int baseDurationTicks = class_3518.method_15282((JsonObject)jsonObject, (String)"base_duration_ticks", (int)1600);
        int color = class_3518.method_15282((JsonObject)jsonObject, (String)"potion_color", (int)-1);
        float potencyModifier = class_3518.method_15277((JsonObject)jsonObject, (String)"potency_modifier", (float)1.0f);
        class_2960 statusEffectIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"effect"));
        if (!class_2378.field_11159.method_10250(statusEffectIdentifier)) {
            throw new JsonParseException("Potion Workshop Brewing Recipe " + identifier + " has a status effect set that does not exist or is disabled: " + statusEffectIdentifier);
        }
        class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(statusEffectIdentifier);
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, craftingTime, ingredient1, ingredient2, ingredient3, statusEffect, baseDurationTicks, potencyModifier, color, applicableToPotions, applicableToTippedArrows, applicableToPotionFillabes);
    }

    public void write(class_2540 packetByteBuf, PotionWorkshopBrewingRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeInt(recipe.craftingTime);
        recipe.ingredient1.method_8088(packetByteBuf);
        recipe.ingredient2.method_8088(packetByteBuf);
        recipe.ingredient3.method_8088(packetByteBuf);
        packetByteBuf.method_10812(class_2378.field_11159.method_10221((Object)recipe.statusEffect));
        packetByteBuf.writeInt(recipe.baseDurationTicks);
        packetByteBuf.writeFloat(recipe.potencyModifier);
        packetByteBuf.writeInt(recipe.color);
        packetByteBuf.writeBoolean(recipe.applicableToPotions);
        packetByteBuf.writeBoolean(recipe.applicableToTippedArrows);
        packetByteBuf.writeBoolean(recipe.applicableToPotionFillabes);
    }

    public PotionWorkshopBrewingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        int craftingTime = packetByteBuf.readInt();
        class_1856 ingredient1 = class_1856.method_8086((class_2540)packetByteBuf);
        class_1856 ingredient2 = class_1856.method_8086((class_2540)packetByteBuf);
        class_1856 ingredient3 = class_1856.method_8086((class_2540)packetByteBuf);
        class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(packetByteBuf.method_10810());
        int baseDurationTicks = packetByteBuf.readInt();
        float potencyModifier = packetByteBuf.readFloat();
        int color = packetByteBuf.readInt();
        boolean applicableToPotions = packetByteBuf.readBoolean();
        boolean applicableToTippedArrows = packetByteBuf.readBoolean();
        boolean applicableToPotionFillabes = packetByteBuf.readBoolean();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, craftingTime, ingredient1, ingredient2, ingredient3, statusEffect, baseDurationTicks, potencyModifier, color, applicableToPotions, applicableToTippedArrows, applicableToPotionFillabes);
    }

    public static interface RecipeFactory<PotionWorkshopBrewingRecipe> {
        public PotionWorkshopBrewingRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, int var5, class_1856 var6, class_1856 var7, class_1856 var8, class_1291 var9, int var10, float var11, int var12, boolean var13, boolean var14, boolean var15);
    }
}

