/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

public class PotionWorkshopCraftingRecipe
extends PotionWorkshopRecipe {
    protected final class_1856 baseIngredient;
    protected final boolean consumeBaseIngredient;
    protected final int requiredExperience;
    protected final class_1799 output;

    public PotionWorkshopCraftingRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, class_1856 baseIngredient, boolean consumeBaseIngredient, int requiredExperience, class_1856 ingredient1, class_1856 ingredient2, class_1856 ingredient3, class_1799 output, int craftingTime, int color) {
        super(id, group, secret, requiredAdvancementIdentifier, craftingTime, color, ingredient1, ingredient2, ingredient3);
        this.output = output;
        this.baseIngredient = baseIngredient;
        this.requiredExperience = requiredExperience;
        this.consumeBaseIngredient = consumeBaseIngredient;
        this.registerInToastManager(this.method_17716(), this);
    }

    public class_1856 getBaseIngredient() {
        return this.baseIngredient;
    }

    public boolean consumesBaseIngredient() {
        return this.consumeBaseIngredient;
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_CRAFTING;
    }

    @Override
    public boolean usesReagents() {
        return false;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return null;
    }

    @Override
    public boolean isValidBaseIngredient(class_1799 itemStack) {
        return this.baseIngredient.method_8093(itemStack);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)class_1856.method_8101((class_1799[])new class_1799[]{SpectrumItems.MERMAIDS_GEM.method_7854()}));
        defaultedList.add((Object)this.baseIngredient);
        defaultedList.add((Object)this.ingredient1);
        defaultedList.add((Object)this.ingredient2);
        defaultedList.add((Object)this.ingredient3);
        return defaultedList;
    }

    @Override
    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        if (this.enoughExperienceSupplied(inv)) {
            return super.method_8115(inv, world);
        }
        return false;
    }

    private boolean enoughExperienceSupplied(class_1263 inv) {
        if (this.requiredExperience > 0) {
            for (int i : new int[]{1, 2, 3, 4}) {
                if (!(inv.method_5438(i).method_7909() instanceof ExperienceStorageItem)) continue;
                return ExperienceStorageItem.getStoredExperience(inv.method_5438(i)) >= this.requiredExperience;
            }
        }
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    @Override
    public int getMinOutputCount(class_1799 itemStack) {
        return 1;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_crafting";
    }
}

