/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1869;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class PotionWorkshopReactingRecipeSerializer
implements GatedRecipeSerializer<PotionWorkshopReactingRecipe> {
    public final RecipeFactory<PotionWorkshopReactingRecipe> recipeFactory;

    public PotionWorkshopReactingRecipeSerializer(RecipeFactory<PotionWorkshopReactingRecipe> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public PotionWorkshopReactingRecipe read(class_2960 identifier, JsonObject jsonObject) {
        List<PotionMod> mods;
        if (!jsonObject.has("modifiers")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_1792 item = class_1869.method_8155((JsonObject)jsonObject);
        if (class_3518.method_15264((JsonObject)jsonObject, (String)"modifiers")) {
            JsonArray modifiers = class_3518.method_15261((JsonObject)jsonObject, (String)"modifiers");
            mods = StreamSupport.stream(modifiers.spliterator(), false).map(jsonElement -> PotionMod.fromJson(jsonElement.getAsJsonObject())).collect(Collectors.toList());
        } else {
            JsonObject modifiers = class_3518.method_15296((JsonObject)jsonObject, (String)"modifiers");
            mods = Collections.singletonList(PotionMod.fromJson(modifiers));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, item, mods);
    }

    public void write(class_2540 packetByteBuf, PotionWorkshopReactingRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.method_10812(class_2378.field_11142.method_10221((Object)recipe.item));
        packetByteBuf.writeInt(recipe.modifiers.size());
        for (PotionMod mod : recipe.modifiers) {
            mod.write(packetByteBuf);
        }
    }

    public PotionWorkshopReactingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(packetByteBuf.method_10810());
        ArrayList<PotionMod> mods = new ArrayList<PotionMod>();
        int modCount = packetByteBuf.readInt();
        for (int i = 0; i < modCount; ++i) {
            mods.add(PotionMod.fromPacket(packetByteBuf));
        }
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, item, mods);
    }

    public static interface RecipeFactory<PotionWorkshopReactingRecipe> {
        public PotionWorkshopReactingRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_1792 var5, List<PotionMod> var6);
    }
}

