/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopReactingRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionWorkshopRecipe
extends GatedSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("progression/unlock_potion_workshop");
    public static final int[] INGREDIENT_SLOTS = new int[]{2, 3, 4};
    protected final int craftingTime;
    protected final int color;
    protected final class_1856 ingredient1;
    protected final class_1856 ingredient2;
    protected final class_1856 ingredient3;

    public PotionWorkshopRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, int craftingTime, int color, class_1856 ingredient1, class_1856 ingredient2, class_1856 ingredient3) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.color = color;
        this.craftingTime = craftingTime;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.ingredient3 = ingredient3;
    }

    public List<class_1856> getOtherIngredients() {
        ArrayList<class_1856> ingredients = new ArrayList<class_1856>();
        ingredients.add(this.ingredient1);
        if (!this.ingredient2.method_8103()) {
            ingredients.add(this.ingredient2);
            if (!this.ingredient3.method_8103()) {
                ingredients.add(this.ingredient3);
            }
        }
        return ingredients;
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        if (inv.method_5439() > 4 && inv.method_5438(0).method_31574((class_1792)SpectrumItems.MERMAIDS_GEM) && this.isValidBaseIngredient(inv.method_5438(1))) {
            if (this.usesReagents() ? !this.areStacksInReagentSlotsAllReagents(inv) : !this.areReagentSlotsEmpty(inv)) {
                return false;
            }
            return PotionWorkshopRecipe.matchIngredientStacksExclusively(inv, this.getOtherIngredients(), INGREDIENT_SLOTS);
        }
        return false;
    }

    private boolean areStacksInReagentSlotsAllReagents(@NotNull class_1263 inv) {
        for (int i : new int[]{5, 6, 7, 8}) {
            class_1799 itemStack = inv.method_5438(i);
            if (itemStack.method_7960() || PotionWorkshopReactingRecipe.isReagent(itemStack.method_7909())) continue;
            return false;
        }
        return true;
    }

    private boolean areReagentSlotsEmpty(@NotNull class_1263 inv) {
        for (int i : new int[]{5, 6, 7, 8}) {
            class_1799 itemStack = inv.method_5438(i);
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isValidBaseIngredient(class_1799 var1);

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_17447() {
        return SpectrumBlocks.POTION_WORKSHOP.method_8389().method_7854();
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.ANVIL_CRUSHING_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.ANVIL_CRUSHING;
    }

    public abstract boolean usesReagents();

    public abstract int getMinOutputCount(class_1799 var1);

    public int getColor() {
        return this.color;
    }

    @Override
    @Nullable
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }
}

